<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="ametys docbook"
                              extension-element-prefixes="text resolver user">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">member-in-chart</xsl:variable>
	
	<xsl:template name="common-content-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_search.css')}" />
	</xsl:template>
	
	<xsl:template name="common-content-body">
		<div class="{$common-content-css-class-name}">
        	<xsl:call-template name="common-content-body-content"/>
        </div>
    </xsl:template>
	
	<xsl:template name="common-content-body-content">
		<xsl:variable name="page-id" select="user:getUserPage(@id)"/>
		
		<!-- Image -->
		<a href="{resolver:resolve('page', $page-id, false)}">
<!-- 			<xsl:variable name="nomImage"><xsl:value-of select="metadata/login"/>.jpg</xsl:variable> -->
    	
<!-- 	    	<xsl:choose> -->
<!-- 	    		<xsl:when test="metadata/illustration/image"> -->
<!-- 		    		<div class="picture" data-ametys-metadata="{@id};illustration/image"> -->
<!-- 		                <img src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, '40', '40')}" alt="{metadata/illustration/alt-text}"/> -->
<!-- 		            </div> -->
<!-- 	    		</xsl:when> -->
<!-- 	    		<xsl:when test="ametys:resourcesByPath('Agents')/resource[@name = $nomImage]"> -->
<!-- 		    		<div class="picture" data-ametys-metadata="{@id};illustration/image"> -->
<!-- 		    			<div class="content-illustration profil ametys-profile-header__img"> -->
<!-- 		    				<img src="{resolver:resolveCroppedImage('explorer', ametys:resourcesByPath('Agents')/resource[@name = $nomImage]/@id,40,40)}"/> -->
<!-- 		    			</div> -->
<!-- 		    		</div> -->
<!-- 	    		</xsl:when> -->
<!-- 	    		<xsl:otherwise> -->
<!-- 			    	<div class="picture" data-ametys-metadata="{@id};illustration/image"> -->
<!-- 		    			<img src="{ametys:skinURL('templates/common/img/avatar.png')}" width="40"/> -->
<!-- 			    	</div> -->
<!-- 	    		</xsl:otherwise> -->
<!-- 	    	</xsl:choose> -->
			<span><xsl:value-of select="metadata/firstname"/><xsl:text> </xsl:text><xsl:value-of select="metadata/lastname"/></span>
        </a>
        	
		<!-- Member name -->
    </xsl:template>
    
</xsl:stylesheet>