<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys resolver">

    <xsl:import href="plugin:forms://stylesheets/forms/helper/entry-information.xsl"/>
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_FORMAT'), $lang)"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_TIME_FORMAT'), $lang)"></xsl:variable>
    
    <xsl:template match="field[@type='DATE']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{value}"/>
    </xsl:template>
    
    <xsl:template match="field[@type='DATETIME']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{value}"/>
    </xsl:template>
</xsl:stylesheet>
