<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="skin://stylesheets/others.xsl" />
    <xsl:import href="plugin:welcome-tour?://stylesheets/helper.xsl"/>
	
	<xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')"/>
	
	<xsl:variable name="catalogHomeUrl">
        <xsl:choose>
            <xsl:when test="$catalogSiteName != '' and ametys:pageExists($catalogSiteName, $lang, 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/', $lang, '/index.html')"/>
            </xsl:when>
            <xsl:when test="$catalogSiteName != '' and $lang != 'fr' and ametys:pageExists($catalogSiteName, 'fr', 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/fr/index.html')"/>
            </xsl:when>
            <xsl:when test="$catalogSiteName != '' and $lang != 'en' and ametys:pageExists($catalogSiteName, 'en', 'index')">
                <xsl:value-of select="concat(ametys:absoluteSiteUriPrefix($catalogSiteName), '/en/index.html')"/>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="additionnal-css">
        <!-- Home Page Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/page_home.css')}" />
        <!-- END::Home Page Styles -->
        <xsl:call-template name="head-tour-css"/>
    </xsl:template>
        
    <xsl:template name="head-tour-css">
        <xsl:if test="$tourEnabled">
            <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/tour/scss/main.css')}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <xsl:call-template name="head-tour-js"/>
    </xsl:template>
    
    <xsl:template name="head-tour-js">
        <xsl:call-template name="welcome-tour-js"/>
        <xsl:if test="$tourEnabled">
            <script type="text/javascript" src="{ametys:skinURL('templates/common/js/tour-transitions.js')}"></script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="body">
        <body class="home has-alert">
        	<xsl:call-template name="accessibility-links"/>
        	
        	<xsl:call-template name="alertes"/>
        	
            <xsl:call-template name="header"/>
            
            <main role="main" id="main-content">
                <div class="background home">
                    <xsl:call-template name="body-background-image"/>
                    
                    <xsl:call-template name="welcome"/>
                    
                    <xsl:call-template name="header-main-search"/>
                    
                    <xsl:call-template name="acces-rapides"/>
                </div>
            
                <xsl:call-template name="zones"/>
            
    		    <xsl:call-template name="acces-rapides-burger"/>
            </main>
    		<xsl:call-template name="footer"/>
    		<xsl:call-template name="scroll-top"/>
        </body>
    </xsl:template>
    
    <xsl:template name="zones">
        <!--  Header -->
        <div class="a-la-une">
            <zone name="header" level="1"/>
        </div>
        
        <!-- Default -->
        <xsl:call-template name="main-zone"/>
        
        <!-- Zone files (2 columns) -->
        <xsl:call-template name="zone-file"/>
        
        <!-- Zone split (2 columns) -->
        <xsl:call-template name="zone-split"/>
        
        <!-- Zone middle (large)-->
        <xsl:call-template name="zone-middle-large"/>
        
        <!-- Zone 2 columns (workspaces services) -->
        <xsl:call-template name="zone-double-column"/>
        
        <!-- Zone bottom (large)-->
        <xsl:call-template name="zone-bottom"/>
        
        
    </xsl:template>
    
    <xsl:template name="zone-file">
        <xsl:if test="ametys:renderingContext() = 'back' or /cms/page/pageContents/zone[@name='middle' or @name='aside']/zoneItem">
            <div class="ametys-zone-file">
                <div class="file-left">
                    <zone name="middle" level="2"/>
                </div>
                <div class="file-right">
                    <zone name="aside" level="2"/>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="zone-split">
        <xsl:if test="ametys:renderingContext() = 'back' or /cms/page/pageContents/zone[@name='bottom-left' or @name='bottom-right']/zoneItem">
            <div class="zone-background-split">
                <div class="zone-1">
                    <zone name="bottom-left" level="2"/>
                </div>
                <div class="zone-2">
                    <zone name="bottom-right" level="2"/>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="zone-bottom">
        <xsl:if test="ametys:renderingContext() = 'back' or /cms/page/pageContents/zone[@name='bottom']/zoneItem">
            <div class="ametys-zone-kiosque">
                <zone name="bottom" level="2"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="zone-double-column">
        <xsl:if test="ametys:renderingContext() = 'back' or /cms/page/pageContents/zone[@name='column-left' or @name='column-right']/zoneItem">
            <div class="ametys-cms-double-column">
                <div class="container">
                    <div class="ametys-zone-activity-feed">
                        <zone name="column-left" level="2"/>
                    </div>
                    <div class="ametys-zone-community">
                        <zone name="column-right" level="2"/>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="zone-middle-large">
        <xsl:if test="ametys:renderingContext() = 'back' or /cms/page/pageContents/zone[@name='middle-large']/zoneItem">
            <div class="ametys-zone-kiosque">
                <zone name="middle-large" level="2"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="welcome">
        <h1>Bonjour <xsl:value-of select="$currentUser/user/firstname"/></h1>
    </xsl:template>
    
    <xsl:template name="acces-rapides">
    	<xsl:if test="cms/inputData/linkDirectory/links/link[themes/theme/@id='ACCES_RAPIDES']">
    	<div class="page-container-transparent">
            <div class="access">
                <xsl:call-template name="acces-rapides-title"/>
				
                <xsl:call-template name="acces-rapides-ul"/>
            </div>
        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="acces-rapides-title">
       <h2 class="service-title"><i18n:text i18n:key="SKIN_ACCESS_RAPIDES_LABEL" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
     <xsl:template name="acces-rapides-burger">
    	<xsl:if test="cms/inputData/linkDirectory/links/link[themes/theme/@id='ACCES_RAPIDES']">
            <div class="ametys-cms-service ametys-zone-access access-home link-directory">
                <h2 class="service-title"><i18n:text i18n:key="SKIN_ACCESS_RAPIDES_LABEL" i18n:catalogue="skin.{$skin}"/></h2>
				
                <xsl:call-template name="acces-rapides-ul"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-button"/>
    
    <xsl:template name="zone-item-before">
        <xsl:param name="position"/>
        <xsl:param name="count"/>
        <xsl:param name="zone-name"/>
        <xsl:param name="level"/>
        <xsl:param name="inherited"/>
        <xsl:param name="id"/>
        <xsl:param name="type"/>
        <xsl:param name="content-id"/>
        <xsl:param name="service"/>
        <xsl:param name="content-type"/>
        
        <xsl:if test="$zone-name = 'middle'">
        	<xsl:attribute name="class">
        		<xsl:text>nav-item nav-</xsl:text><xsl:value-of select="$position"/>
        		<xsl:if test="$position = '1'"> active</xsl:if>
        </xsl:attribute>
        </xsl:if>

     </xsl:template>
    
</xsl:stylesheet>