function openOrCloseMainMenu(currentStep, nextStep)
{
	let nextParams = nextStep['transitionParams'] || {};
	if (nextParams.type == "main-menu")
	{
		var mobile = $j('header .icons .burger').is(':visible');
		if (mobile && !$j('.menu-mobile.open').length)
		{
			openMenuMobile($j('header .icons .burger')[0]); // open mobile main menu
			return 300;
		}
		else if (!mobile)
		{
			window.scrollTo({ top: 0, behavior: 'smooth' }); // scroll top
		}
	}
	else if ($j('.menu-mobile.open').length)
	{
		closeMenuMobile(); // close mobile main menu
		return 300;
	}
	return 0;
}

function openOrCloseUserMenu(currentStep, nextStep)
{
	let nextParams = nextStep['transitionParams'] || {};
    if (nextParams.type == "user-menu" && !$j('.nav-perso.open').length)
    {
		openNavPerso(); // open user menu
		return 300;
	}
	else if (nextParams.type != "user-menu" && $j('.nav-perso.open').length)
	{
		closeNavPerso();
		return 300;
	}
	return 0;
}

function selectMainMenuItem(step)
{
	let params = step['transitionParams'] || {};
	let position = params.position || 1;
	
	var isMobileMenu = $j('.menu-mobile.open').length != 0;
	if (isMobileMenu)
	{
		return $j(`.menu-mobile.open nav > ul > li:nth-child(${position})`)[0];
	}
	else 
	{
		return $j(`header[role=banner] .container nav > ul > li:nth-child(${position})`)[0];
	}
}

AmetysFront.WelcomeTour.transitionFunction = function(currentStep, nextStep)
{
    let transitions = [openOrCloseUserMenu, openOrCloseMainMenu];
    let delays = transitions.map(t => t.apply(null, [currentStep, nextStep]))
    return Math.max(...delays);
}
