<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <xsl:variable name="is-empty" select="count(/subscriptions/subscription) = 0"/>    
    
    <!-- Refresh delay for unread pages -->
    <xsl:variable name="pageFollowRefreshDelay" select="ametys:siteParameter('page-follow-refresh-delay') * 60000"/><!-- refresh delay in min -->
    
    <xsl:variable name="dataSettings">{}</xsl:variable><!-- define number of rows displayed on load -->
                 
    <xsl:variable name="common-service-css-class-name">zone-abo favourites-inline</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/animate.css')}" type="text/css" />

        <link rel="stylesheet" href="{ametys:skinURL('zones/abo-tools/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/abo-tools/scss/print.css')}"/>
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL(concat('templates/common/js/ametys-tools.', ametys:lang(), '.js'))}"></script>
        
        <!-- Tooltip -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/popper.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
        
        <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/page-subscription/resources/js/AmetysFront/UserPageSubscriptions.', ametys:lang(), '.js')}"/>   
        
        <script type="text/javascript">
            $j(function(){
              var $tool = $j('#tool-<xsl:value-of select="$uniqueId"/>');
              $tool.HSAmetysTools($j('#tool-<xsl:value-of select="$uniqueId"/>').data('settings'));
              $tool.on('elementDeleted', unsubscribe_<xsl:value-of select="$uniqueId"/>);
              
              AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-<xsl:value-of select="$uniqueId"/>', updateTooltip_<xsl:value-of select="$uniqueId"/>);
              
              setInterval(function() {
                AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-<xsl:value-of select="$uniqueId"/>');
              }, <xsl:value-of select="$pageFollowRefreshDelay"/>, updateTooltip_<xsl:value-of select="$uniqueId"/>);
             
            
                var pageFollowTimer = null;
                
                AmetysFront.Event.listen("followed-pages-opened", function(data) {
                    // On open get unread pages
                    AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-<xsl:value-of select="$uniqueId"/>', updateTooltip_<xsl:value-of select="$uniqueId"/>);
                    
                    pageFollowTimer = setInterval(function() {
                        AmetysFront.UserPageSubscriptions.getUnreadPages('#tool-ametys_<xsl:value-of select="$uniqueId"/>', updateTooltip_<xsl:value-of select="$uniqueId"/>);
                      }, <xsl:value-of select="$pageFollowRefreshDelay"/>);
                })
                
                AmetysFront.Event.listen("followed-pages-closed", function(data) {
                    clearInterval(pageFollowTimer);
                    pageFollowTimer = null;
                })
            });
            
            // Tippy plugin to hide tooltip on ESC
            const hideTooltipOnEsc_<xsl:value-of select="$uniqueId"/> = {
              name: 'hideOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
            function updateTooltip_<xsl:value-of select="$uniqueId"/>(unreadPages)
            {
                $j.each(unreadPages, function(i, unreadPage) {
                
                    // Destroy tooltips
                    $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + ']').each(function(i, el) {
                        if ($j(el).get(0)._tippy)
                        {
                            $j(el).get(0)._tippy.destroy();
                        }
                    })
                    
                    $j.each(unreadPages, function(i, unreadPage) {
                        let $el = $j('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]');
                        
                        // Create tooltip
                        tippy('[' + AmetysFront.UserPageSubscriptions.PAGE_NOTIFICATION_ID_ATTR + '="' + unreadPage.pageId + '"]', {
                            allowHTML: true,
                            content: $el.html(),
                            placement: 'bottom-end',
                            plugins: [hideTooltipOnEsc_<xsl:value-of select="$uniqueId"/>],
                            theme: 'notification'
                        });
                        
                        $el.attr("tabindex", 0); // to show tooltip on focus
                    });
                });
            }
            
            // Unsubscribe
            function unsubscribe_<xsl:value-of select="$uniqueId"/>(event, target)
            {
                let subscriptionId = $j(target).attr("data-ametys-subscription-id");
                AmetysFront.UserPageSubscriptions.unsubscribe('<xsl:value-of select="$uniqueId"/>', subscriptionId, null, true /* skipConfirm */)
            };
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <div class="title">
             <h2>
                <xsl:choose>
                    <xsl:when test="$header">
                        <xsl:copy-of select="$header"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="header-default-title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </h2>
            <xsl:call-template name="configure-button"/>
        </div>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="tool-{$uniqueId}" data-settings="{normalize-space($dataSettings)}">
			<input data-edit-mode-toggle="" type="checkbox" id="tool-toggle-{$uniqueId}" class="ametys-toggle__check ametys-edit-mode-checker" style="display: none;"/>
            
            <!-- Selected links -->
            <div class="ametys-tools">
                <p data-no-items-text="" class="ametys-tools-no-items-text" data-ametys-subscription-page-role="no-result"><i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_NOSUBSCRIPTION" i18n:catalogue="skin.{$skin}"/></p>

                <div id="selected-links-ametys_{$uniqueId}" data-list-wrap="" class="ametys-tools-list-wrap ametys-animated-heigth ametys-abonnements-tools-list" data-ametys-subscriptions="{$uniqueId}">
                    <ul data-list="" class="ametys-tools-list ametys-tools-list_editable">
                        <xsl:apply-templates select="/subscriptions/subscription"/>
                    </ul>
                </div>
                
                <p class="sr-only" role="status" data-ametys-subscription-page-role="status"></p>
            </div>
                
            <!-- Modal -->
            <xsl:call-template name="unsubscribe-modal">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:call-template>
		</div>
    </xsl:template>
    
    <xsl:template name="header-default-title">
        <i18n:text i18n:key="SKIN_USER_MENU_FOLLOWED_PAGES" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="configure-button">
        <button type="button" onclick="toggleCheckbox_{$uniqueId}(this)" aria-label="skin.{$skin}:LINK_DIRECTORY_CONFIGURE_LABEL" i18n:attr="aria-label">
            <span><i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE" i18n:catalogue="skin.{$skin}"/></span>
            <i aria-hidden="true" class="fa fa-cog"></i>
        </button>
        
        <script type="text/javascript">
            function toggleCheckbox_<xsl:value-of select="$uniqueId"/>(el) {
                $j("#tool-toggle-<xsl:value-of select="$uniqueId"/>").trigger('click');
                $j(el).toggleClass('active');

                if ($j(el).hasClass('active')) {
                    $j(el).find('span').html("<i18n:text i18n:key="LINK_DIRECTORY_CLOSE" i18n:catalogue="skin.{$skin}"/>");
                    $j(el).attr("aria-label", "<i18n:text i18n:key="LINK_DIRECTORY_CLOSE_LABEL" i18n:catalogue="skin.{$skin}"/>");
                    
                    $j(".ametys-tools-list__link")
                        .each(function () {
                            $j(this).attr('data-href', $j(this).attr('href'));
                            $j(this).attr('href', 'javascript:void(0)');
                            $j(this).removeAttr('target');
                        });
                
                } else {
                    $j(el).find('span').html("<i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE" i18n:catalogue="skin.{$skin}"/>");
                    $j(el).attr("aria-label", "<i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE_LABEL" i18n:catalogue="skin.{$skin}"/>");
                    $j(".ametys-tools-list__link")
                        .each(function () {
                            $j(this).attr('href', $j(this).attr('data-href'));
                            $j(this).attr('target', '_blank');
                        });
                }
            }
        </script>
    </xsl:template>
    
    <xsl:template match="subscription">
        <li class="ametys-tools-list__item ametys-tools-list__abo" data-list-item="" data-app-type="custom" data-ametys-subscription-id="{@id}">
            <a class="ametys-tools-list__link"
               href="{resolver:resolve('page', page/@id, false)}"
               data-list-link="">
                                  
              <div class="ametys-abonnements">
                   <xsl:apply-templates select="." mode="breadcrumb"/>     
                   <xsl:apply-templates select="." mode="title"/>  
                   <xsl:apply-templates select="." mode="notification"/>    
              </div>
           </a>
                                  
           <button type="button" aria-label="skin.{$skin}:SERVICE_PAGE_SUBSCRIPTION_UNSUBSCRIBE" i18n:attr="aria-label" class="material-icons ametys-tools-list__action">close</button>
        </li>
    </xsl:template>
    
    <xsl:template match="subscription" mode="breadcrumb">
        <p class="ametys-abonnements__breadcrumb">
            <xsl:if test="ametys:pageExists($site, $lang, 'index')">
                <xsl:value-of select="ametys:pageTitle($site, $lang, 'index')"/>
            </xsl:if>
            <xsl:variable name="breadcrumb" select="ametys:breadcrumb(page/@id)"/>
            <xsl:for-each select="$breadcrumb[position() &lt;= 2]">
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle(.)"/>
            </xsl:for-each>
            <xsl:if test="count($breadcrumb) &gt; 2">
                <xsl:if test="count($breadcrumb) &gt; 3"><xsl:text> / ...</xsl:text></xsl:if>
                <xsl:text> / </xsl:text>
                <xsl:value-of select="ametys:pageTitle($breadcrumb[position() = last()])"/>
            </xsl:if>
          </p>
    </xsl:template>
    
    <xsl:template match="subscription" mode="title">
        <h3 class="ametys-abonnements__title">
          <xsl:value-of select="page"/> 
        </h3>
    </xsl:template>
    
    <xsl:template match="subscription" mode="notification">
        <div class="ametys-abonnement__circle" data-ametys-page-notification-id="{page/@id}" style="display: none">
            <div class="ametys-abonnement__last-edit">
                <span class="ametys-abonnement__last-edit__date" data-ametys-page-notification-role="date"></span>
                <div class="ametys-abonnement__last-edit__user">
                    <img alt="" data-ametys-page-notification-role="author-img"/>
                    <div class="ametys-abonnement__last-edit__user__info">
                        <span class="ametys-abonnement__last-edit__user__info__name" data-ametys-page-notification-role="author-name"></span>
                        <span class="ametys-abonnement__last-edit__user__info__action">
                            <i18n:text i18n:key="SERVICE_PAGE_SUBSCRIPTION_PAGE_MODIFIED" i18n:catalogue="skin.{$skin}"/>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="unsubscribe-modal">
        <!-- Delete confirm -->
         <div id="data-delete-modal-{$uniqueId}" class="modal-confirm" style="display: none;"
            data-delete-modal="" aria-labelledby="delete-modal-title_{$uniqueId}" role="dialog" aria-modal="true">
            <h1 id="delete-modal-title_{$uniqueId}"><i18n:text i18n:key="PAGE_SUBSCRIPTION_HELPER_UNSUBSCRIBE_CONFIRM_MSG" i18n:catalogue="plugin.page-subscription"/></h1>
            <button data-delete-modal-close="" class="close" aria-label="skin.{$skin}:SKIN_USER_MENU_CLOSE" i18n:attr="aria-label"><i aria-hidden="true" class="fas fa-times"></i></button>
            
            <div class="">
                <button class="btn full" data-delete-modal-confirm=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_YES" i18n:catalogue="skin.{$skin}"/></span></button>
                <button class="btn" data-delete-modal-close=""><span><i18n:text i18n:key="SKIN_USER_MENU_CONFIRM_NO" i18n:catalogue="skin.{$skin}"/></span></button>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
