<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        xmlns:math="http://exslt.org/math"
		exclude-result-prefixes="ametys">
	
	<xsl:import href="skin://services/web/pages/services/attachments.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="is-empty" select="not(/Attachments/Folder) and not(/Attachments/File)"/>    
    <xsl:variable name="common-service-name">service-attachments</xsl:variable> 
    
    <xsl:variable name="id" select="concat('attachment_', substring-after(math:random(), '.'))"/>    
    
    <xsl:template name="list-folders">
        <xsl:apply-templates select="Folder" mode="folder"/>
    </xsl:template>
    
    <xsl:template name="list-files">
        <xsl:apply-templates select="File" mode="file"/>
    </xsl:template>
    
    <xsl:template match="File" mode="file-href-attr">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('attachment-page', @id, true())"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="File" mode="file-size">
        <span class="extension">(<xsl:value-of select="size"/>)</span>
    </xsl:template>
</xsl:stylesheet>		
