<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="skin://services/web/pages/services/search/search-default.xsl"/>
    
    <!-- No sort and no results count -->
    <xsl:template name="form-result"/>
    
    <!-- Display pagination only if there is more than one page -->
    <xsl:template name="pagination">
        <xsl:copy-of select="/search/pagination"/>
        <xsl:if test="/search/pagination/@total != '1'">
            <form id="reload">
                <nav class="button-container" role="navigation" aria-label="skin.{$skin}:SKIN_SEARCH_NAV_PAGINATION_LABEL" i18n:attr="aria-label">
                    <ul class="pagination">
                        <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 10, 0)" mode="search-pagination">
                            <xsl:with-param name="original-context-node" select="/"/>
                        </xsl:apply-templates>
                    </ul>
                </nav>
            </form>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>