<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="ametys resolver">    
    
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
    
    <!-- +
         | Set to 'false' to redirect to the media page when clicking on media search's result
         | Set to 'true' to open the media directly when clicking on media search's result (launch video/audio player, open flipbook for PDF document, open photo in popup)
         +-->
    <xsl:variable name="openMediaOnClick">false</xsl:variable>

    <!-- Set to true to display a default image when there is no illustration -->
    <xsl:variable name="useDefaultImage">false</xsl:variable>
    
    <xsl:template name="common-content-body-title-content"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <a>
            <xsl:call-template name="content-link-class-attribute"/>
            <xsl:choose>
                <xsl:when test="$openMediaOnClick = 'true'">
                    <xsl:call-template name="content-open-media-attributes"/>
                </xsl:when>
                <xsl:when test="$page-id != ''">
                    <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('page', $page-id, false)"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="href">#</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        
            <xsl:call-template name="content"/>
        </a>
        
        <xsl:if test="$openMediaOnClick = 'true'">
            <xsl:call-template name="content-open-media-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-link-class-attribute"/>

    <!-- link attributes to open the media -->    
    <xsl:template name="content-open-media-attributes"/>
    
    <!-- JS to open the media -->    
    <xsl:template name="content-open-media-js"/>
    
    <xsl:template name="content">
        <div class="picture">
            <xsl:call-template name="content-image"/>
            <xsl:call-template name="content-icon"/>
        </div>
        <div class="infos">
            <xsl:if test="not(metadata/illustration/image)">
                <xsl:attribute name="class">infos no-picture</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="content-title"/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alt" select="metadata/illustration/alt-text"/>
        <xsl:param name="maxWidth" select="'250'"/>
        <xsl:param name="maxHeight" select="'250'"/>
        
        <xsl:if test="$image or $useDefaultImage='true'">
             <xsl:choose>
                <xsl:when test="$image">
                    <img src="{resolver:resolveCroppedImage($image/@type, $image/@path, $maxHeight, $maxWidth)}" alt="{$alt}" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="content-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-icon">
        <span class="icon">
            <xsl:call-template name="ctype-icon"/>
        </span>
    </xsl:template>
    
    <!-- Default icon -->
    <xsl:template name="ctype-icon">
        <i class="fas fa-file-alt" aria-hidden="true"></i>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <img src="{ametys:skinURL('templates/common/img/default-article-image.png')}" alt="" />
    </xsl:template>
    
    <xsl:template name="content-title">
        <span class="title">
            <xsl:value-of select="metadata/title"/>
        </span>
    </xsl:template>
    
</xsl:stylesheet>