<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook">

	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
	
    <xsl:variable name="wrapperContentCssClass">item actu-item with-icon</xsl:variable>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="content-date">
        <xsl:if test="metadata/closingDate">
		  <div class="date">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMM"><xsl:value-of select="metadata/closingDate"/></i18n:date>
		  </div>
        </xsl:if>
	</xsl:template>
    
    <xsl:template name="content-icon">
        <span class="intraneticon-job icon"></span>
    </xsl:template>
    
    <xsl:template name="content-default-image-picto">
        <i class="intraneticon-job"></i>
    </xsl:template>
    
</xsl:stylesheet>