<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys resolver docbook"
							xmlns:datetime="http://ametys.org/datetime/4.2"
                            extension-element-prefixes="datetime">

	<xsl:import href="plugin:flipbook://stylesheets/content/pdfDocument/pdfDocument-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
    
    <xsl:variable name="previewWidth">180</xsl:variable>
    <xsl:variable name="previewHeight">240</xsl:variable>
    
	<xsl:template name="common-content-body">
        <xsl:call-template name="document"/>
    </xsl:template>
    
	<xsl:template name="document">
        <xsl:param name="previewWidth" select="$previewWidth"/>
        <xsl:param name="previewHeight" select="$previewHeight"/>
        
        <xsl:if test="metadata/file">
            <a class="focus-reversed" href="{resolver:resolve(concat(metadata/file/@type, '-flipbook'), metadata/file/@path)}" target="_blank">

                <xsl:variable name="filename">
                    <xsl:choose>
                        <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:variable name="i18nparams"><filename><xsl:value-of select="$filename"/></filename></xsl:variable> 
                

                <xsl:attribute name="title">
                    <xsl:value-of select="ametys:translate('plugin.flipbook:CONTENT_PDF_DOCUMENT_BOOK_TITLE', $lang, $i18nparams)"/>
                </xsl:attribute>
                
                <xsl:if test="$rendering-context = 'back'">
                    <xsl:attribute name="internal">internal</xsl:attribute>
                </xsl:if>
                
                <img class="main" src="{resolver:resolveBoundedImage(concat(metadata/file/@type, '-flipbook'), metadata/file/@path, $previewHeight, $previewWidth)}">
                    <xsl:attribute name="alt">
                        <xsl:choose>
                            <xsl:when test="metadata/file-text != ''"><xsl:value-of select="metadata/file-text"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="metadata/file/@filename"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                </img>
                
                <img alt="" src="{ametys:skinURL('templates/common/img/icon/visioner.svg')}" class="icon"/>
            </a>
       </xsl:if>
    </xsl:template>

    <!-- <xsl:template name="get-page-id"/> -->

</xsl:stylesheet>