<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:docbook="http://docbook.org/ns/docbook"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="plugin:multimedia://stylesheets/content/photo/photo-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-media.xsl"/>
    
    <xsl:variable name="useDefaultImage">true</xsl:variable>
    
    <xsl:template name="ctype-icon">
        <i class="far fa-file-image" aria-hidden="true"></i>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <img src="{resolver:resolveCroppedImage(metadata/file/@type, metadata/file/@path, 250, 250)}" alt=""/>
    </xsl:template>
    
    <xsl:template name="content-open-media-attributes">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')"/></xsl:attribute>
        <xsl:attribute name="target">_blank</xsl:attribute>
        <xsl:attribute name="id">photo-link-<xsl:value-of select="$uniqueId"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-open-media-js">
        <script type="text/javascript">
          $j(function() {
            $j("#photo-link-<xsl:value-of select="$uniqueId"/>").fancybox();
          });
        </script> 
    </xsl:template>
    
</xsl:stylesheet>