<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<!--DOCTYPE xsl:stylesheet PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "xhtml1-transitional.dtd"-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:forms="org.ametys.plugins.forms.xslt.FormsXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                exclude-result-prefixes="docbook xlink forms escape">
    
    <xsl:import href="plugin:web://stylesheets/io/docbook2html.xsl"/>
    
    <xsl:template match="docbook:article" priority="1000">
        <xsl:param name="level" select="1"/>
    
        <xsl:apply-templates>
            <xsl:with-param name="level" select="$level"/>
            <xsl:with-param name="localLevel" select="1"/>
        </xsl:apply-templates>
        
        <xsl:if test=".//html:form">
            <script type="text/javascript">
                <xsl:if test="//html:input[@type='file']">
                    function form_changeFile($event, id) {
                        var input = $event;
                        var url = $j($event).val()
                        var ext = url.substring(url.lastIndexOf('.') + 1).toLowerCase();
                        var parts = url.split("\\");
                        var fileName = parts[parts.length - 1];
                        $j('.download-' + id).find('label span').html(fileName);
        
                        if(fileName == '') {
                            $j($event).val('');
                            $j('.download-' + id).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                            $j('.download-' + id).find('.close').fadeOut();
                        } else {
                            $j('.download-' + id).find('.close').fadeIn();
                        }
                    }
        
                    function form_removeFile(e) {
                        const parent = $j(e).parent();
                        $j(parent).find('input').val('');
                        $j(parent).find('label span').html("<i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/>");
                        $j(parent).find('.close').fadeOut();
                    }
                </xsl:if>
                
                // Modify help for accessibility purpose
                var $help = $j('.input-help span');
                $help.addClass("sr-only");
                $help.html($help.parent().attr('title'));
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="html:form//docbook:para" priority="100">
        <div>
           <xsl:attribute name="class">
                <xsl:text>field</xsl:text>
                <xsl:choose>
                    <xsl:when test="html:input/@type = 'checkbox'"> field-checkbox</xsl:when>
                    <xsl:when test="html:input/@type = 'radio'"> field-radio</xsl:when>
                    <xsl:when test="html:textarea"> field-textarea</xsl:when>
                    <xsl:when test="html:input/@regexptype = 'date' or html:input/@regexptype = 'datetime'"> field-date</xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="html:input[@type='file']">
        <xsl:variable name="id" select="@id"/>
        <xsl:variable name="label" select="//html:label[@for = $id]"/>
        
        <div class="input download-input download-{$id}">
            <xsl:if test="@width">
                <xsl:attribute name="style">width: <xsl:value-of select="@width"/>px;</xsl:attribute>
            </xsl:if>
                 
            <button type="button" class="close" onclick="form_removeFile(this)" aria-label="skin.{$skin}:SKIN_FORMS_DELETE_FILE" i18n:attr="aria-label">
                <span class="material-icons">close</span>
            </button>
            <div> 
                <label>
                    <xsl:call-template name="form-input"/>  
                    <span><i18n:text i18n:key="SKIN_FORMS_SELECT_FILE" i18n:catalogue="skin.{$skin}"/></span>
                </label>
                <script>
                    $j('#<xsl:value-of select="@id"/>').on('change', function(){
                        form_changeFile(this, '<xsl:value-of select="@id"/>')
                    })
                    // Handle focus visivility for accessibility purpose
                    $j('#<xsl:value-of select="@id"/>').on('focus', function() {
                        if ($j(this).is(':focus-visible'))
                        {
                            $j(this).closest('.download-input').addClass("focus-visible");
                        }
                    })
                    $j('#<xsl:value-of select="@id"/>').on('blur', function() {
                        $j(this).closest('.download-input').removeClass("focus-visible");
                    })
                </script>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
