<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:datetime="http://ametys.org/datetime/4.2" 
		xmlns:exslt="http://exslt.org/common"
        extension-element-prefixes="datetime" 
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
	<xsl:import href="skin://stylesheets/main.xsl" />
	<xsl:import href="skin://stylesheets/variables.xsl" />
	<xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>

    <xsl:variable name="sections" select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]"/>

    <xsl:variable name="firstZoneItem" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
    <xsl:variable name="mainContent" select="$firstZoneItem[information/type = 'CONTENT']"/>
    <xsl:variable name="mainContentTypeId" select="$mainContent/information/type-information/@id"/>
    <xsl:variable name="mainImgAttributePath">
        <xsl:choose>
            <xsl:when test="$mainContentTypeId = 'org.ametys.plugins.classified.ads.Content.ads'">illustrations/image1</xsl:when>
            <xsl:otherwise>illustration/image</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mainImgAttributeAltPath">
        <xsl:choose>
            <xsl:when test="$mainContentTypeId = 'org.ametys.plugins.classified.ads.Content.ads'"></xsl:when>
            <xsl:otherwise>illustration/alt-text</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mainImgPath" select="$mainContent/html/head/meta[@name = concat($mainImgAttributePath, ';path')]/@content"/>
    <xsl:variable name="mainImgType" select="$mainContent/html/head/meta[@name = concat($mainImgAttributePath, ';type')]/@content"/>
    <xsl:variable name="mainImgAltText" select="$mainContent/html/head/meta[@name = $mainImgAttributeAltPath]/@content"/>
    
    <xsl:variable name="hideIllustration" select="ametys:templateParameter('hideIllustration')"/>
    <xsl:variable name="hasMainImg" select="not($hideIllustration = 'true') and $mainImgPath"/>
    
    <xsl:variable name="hideNavInterieur" select="ametys:templateParameter('hideNavInterieur')"/>
    
    <xsl:variable name="deactivateFOEditionToolbar" select="ametys:templateParameter('deactivateFOEditionToolbar')"/>

    <xsl:template name="additionnal-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/breadcrumb_src.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/static_service_access.css')}" />
    </xsl:template>
    
	<xsl:template name="additionnal-script">
        <!-- FO edition https://docs.ametys.org/fr/plugins/front-edition/v1/manuel-d-integration/barre-d-outils-pour-la-modification-front-office.html -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">2</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="true()"/>
        </xsl:call-template>
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/edition-fo.css')}" />
    </xsl:template>    

	<xsl:template name="has-img">
        <xsl:attribute name="class"><xsl:text>background internal</xsl:text>
            <xsl:choose>
                <xsl:when test="$hasMainImg"> has-img</xsl:when>
                <xsl:otherwise> no-img</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
	</xsl:template>
    
    <xsl:template name="sections">
    	<xsl:if test="$sections">
			<div id="categories_scroll" class="ametys-scroll-via-btn">
				<div class="ametys-filter-categories-wrap">
	                <ul class="ametys-filter-categories ametys-filter-categories--alt">
	                	<xsl:for-each select="$sections">
	                		<xsl:call-template name="section"/>
	                	</xsl:for-each>
	                </ul>
	            </div>
	            <button type="button" data-btn-right="data-btn-right">
					<i class="fas fa-angle-right"></i>
				</button>
				<button type="button" data-btn-left="data-btn-left">
					<i class="fas fa-angle-left"></i>
				</button>
	        </div>
			<script>
				var currentLeft,
						$target = $('#categories_scroll .ametys-filter-categories-wrap');
				
				$('#categories_scroll [data-btn-right]').on('click', function () {
					currentLeft = $target.scrollLeft();
					$target.stop()
							.animate({
								scrollLeft: currentLeft + 200
							}, 400);
				});
				
				$('#categories_scroll [data-btn-left]').on('click', function () {
					currentLeft = $target.scrollLeft();
					$target.stop()
							.animate({
								scrollLeft: currentLeft - 200
							}, 400);
				});
			</script>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="section">
		<li>
	 		<a href="{resolver:resolve('page', @sitemap:id)}">
	 			<xsl:attribute name="class">
	 				<xsl:text>ametys-filter-categories-btn</xsl:text>
	 				<xsl:if test="@sitemap:in-path = 'true'"> active</xsl:if>
	 			</xsl:attribute>
	 		     <xsl:value-of select="@sitemap:title" />
	 		</a>
		</li>
	</xsl:template>
	
	<!-- First content -->
	<xsl:template name="main-zone">
		<xsl:choose>
    		<xsl:when test="$hasMainImg">
    			<div class="image-internal-container template-{$template}">
                    <xsl:variable name="imgUri"><xsl:value-of select="$mainImgPath"/><xsl:if test="$mainImgType = 'attribute'">?objectId=<xsl:value-of select="$mainContent/information/contentId"/></xsl:if></xsl:variable>
            
                    <img src="{resolver:resolveCroppedImage($mainImgType, $imgUri, 570, 947)}" alt="{$mainImgAltText}" class="img-internal"/>
                    
		    		<div class="top">
			    		<div class="left">
                            <div class="page_actions">
                                <xsl:if test="ametys:renderingContext() = 'front' and $pageFollowEnabled = 'true' and not($deactivatePageSubscription = 'true')">
                                    <xsl:call-template name="page-subscription"/>
                                </xsl:if>
    			    			<xsl:call-template name="matomo-stats"/>
                            </div>
			    			<xsl:call-template name="bread-crumb"/>
                            
			    			<div class="content">
                                <!-- Tags -->
                                <xsl:call-template name="main-content-tags"/>
                                
                                <!-- Title -->
                                <xsl:call-template name="title"/>
                                
			    				<xsl:call-template name="main-content"/>
			    			</div>
			            </div>
			            <xsl:call-template name="right"/>
		            </div>
				</div>
    		</xsl:when>
    		<xsl:otherwise>
    			<div class="page-container template-{$template}">
    				<div class="top">
                        <div class="page_actions">
                            <xsl:if test="ametys:renderingContext() = 'front' and $pageFollowEnabled = 'true' and not($deactivatePageSubscription = 'true')">
                                <xsl:call-template name="page-subscription"/>
                            </xsl:if>
                            <xsl:call-template name="matomo-stats"/>
                        </div>
                            
	        			<div class="left">
	        				<xsl:call-template name="bread-crumb"/>
	        				
				            <div class="content">
		       					<!-- Tags -->
                                <xsl:call-template name="main-content-tags"/>
                                
                                <!-- Title -->
                                <xsl:call-template name="title"/>
                                
			    				<xsl:call-template name="main-content"/>
				        	</div>
				        </div>
				        <xsl:call-template name="right"/>
			        </div>
				</div>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
     <xsl:template name="title">
     	<xsl:variable name="hideTitle" select="ametys:zoneParameter('default', 'hideTitle')" />

        <xsl:if test="$mainContent and $zone = 'default' and (not($hideTitle) or $hideTitle='false')">
            <xsl:variable name="subtitle" select="$mainContent/html/head/meta[@name = 'document-subtitle']/@content"/>
            
            <h1 class="main-title">
                <xsl:value-of select="$firstZoneItem/html/head/title"/>
                
                <xsl:if test="$subtitle != ''">
                    <span class="content-subtitle"><xsl:value-of select="$subtitle"/></span>
                </xsl:if>
            </h1>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-tags">
        
        <xsl:variable name="mainTags">
            <tags>
                <xsl:choose>
                    <xsl:when test="$mainContentTypeId= 'org.ametys.plugins.classified.ads.Content.ads'">
                        <xsl:call-template name="main-content-tags-for-ads"/> 
                    </xsl:when>
                    <xsl:when test="$mainContentTypeId= 'org.ametys.plugins.job-offer.Content.jobOffer'">
                        <xsl:call-template name="main-content-tags-for-joboffer"/> 
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="main-content-tags-for-others"/> 
                    </xsl:otherwise>
                </xsl:choose>
            </tags>
        </xsl:variable>
        
        <xsl:for-each select="exslt:node-set($mainTags)/tags/tag">
            <div class="etiquette">
                <xsl:if test="$useTagColor and @bgColor">
                    <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                </xsl:if>
                <xsl:value-of select="."/>
            </div>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="main-content-tags-for-ads">
        <xsl:if test="$mainContent/html/head/meta[@name = 'category;title']/@content != ''">
            <tag><xsl:value-of select="$mainContent/html/head/meta[@name = 'category;title']/@content"/></tag>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-tags-for-joboffer">
        <xsl:if test="$mainContent/html/head/meta[@name = 'contractType;title']/@content != ''">
        	<tag><xsl:value-of select="$mainContent/html/head/meta[@name = 'contractType;title']/@content"/></tag>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content-tags-for-others">
        <xsl:for-each select="$mainContent/html/head/meta[contains(@name, 'tags/') and not(contains(@name, ';parent'))]">
            <xsl:variable name="tagId" select="substring-after(@name, 'tags/')"/>
            <xsl:variable name="tagPath" select="ametys:tagPath($site, $tagId)"/>
            <xsl:variable name="tagColor" select="ametys:tagColor($site, $tagId)"/>
            
            <xsl:if test="contains($tagPath, 'THEMES')">
                <tag bgColor="{$tagColor/main}" textColor="{$tagColor/text}"><xsl:value-of select="@content"/></tag>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="main-content-dates">
        <xsl:if test="($mainContentTypeId = 'org.ametys.plugins.news.Content.news' or $mainContentTypeId = 'org.ametys.plugins.front-notification.Content.flashinfo')
                    and ($mainContent/html/head/meta[@name = 'start-date']/@content != '' or $mainContent/html/head/meta[@name = 'end-date']/@content != '')
                    and not($mainContent/html/head/meta[@name = 'hide-date']/@content = 'true')">
            <span class="date">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="$mainContent/html/head/meta[@name = 'start-date']/@content"/>
                    <xsl:with-param name="endDate" select="$mainContent/html/head/meta[@name = 'end-date']/@content"/>
                </xsl:call-template>
            </span>                             
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content">
        <xsl:if test="not($deactivateFOEditionToolbar = 'true')">
            <xsl:call-template name="fo-toolbar"/>
    	</xsl:if>
        
		<div class="row">
            <xsl:call-template name="default-zone"/>
        </div>
    </xsl:template>
    
    <xsl:template name="fo-toolbar">
        <xsl:call-template name="ametys-front-edition-page-toolbar">
            <xsl:with-param name="items">['edition-mode', 'add-content', 'add-page', {type: 'menu', label: "<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_MENU_LABEL"  i18n:catalogue="plugin.front-edition"/>", items: [ 'tag', 'rename', 'move', 'schedule-publication', 'delete']}]</xsl:with-param>
            <xsl:with-param name="add-contents-config">
                [
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_ARTICLE" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-newspaper", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_NEWS" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "aside", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_ARTICLE_TO_SIDEAREA" i18n:catalogue="skin.{$skin}"/>"}
                ]
            </xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
               "default-pagetype" : "template",                 
               "default-template" : "page",                 
               "default-pagecontent-type" : "contenttype",   
               "pagetype-card-template-filter": ["page", "full-page"]       
               }</xsl:with-param> 
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="default-zone">
   		<!-- Tags, title and illustration highlight -->
   		<zone name="default" level="2"/>
    </xsl:template>
    
    <xsl:template name="right">
        	<div class="right">
        	    <xsl:if test="not($hideNavInterieur = 'true')">
        	       <xsl:call-template name="navinterieur"/>
        	    </xsl:if>
        	    
	            <xsl:if test="$rendering-context = 'back' or /cms/page/pageContents/zone[@name='aside']/zoneItem">
	        		<zone name="aside" level="2"/>
		        </xsl:if>
        	</div>
    </xsl:template>
    
    <xsl:template name="zone-item-before">
        <xsl:param name="position"/>
        <xsl:param name="count"/>
        <xsl:param name="zone-name"/>
        <xsl:param name="level"/>
        <xsl:param name="inherited"/>
        <xsl:param name="id"/>
        <xsl:param name="type"/>
        <xsl:param name="content-id"/>
        <xsl:param name="service"/>
        <xsl:param name="content-type"/>
        
        <xsl:if test="$zone-name = 'aside'">
        	<xsl:variable name="bgColor" select="ametys:zoneItemParameter($id, 'bgcolor')"/>
        
	        <xsl:if test="$bgColor = 'true'">     
		        <xsl:attribute name="class">with-bg-color</xsl:attribute>     
		    </xsl:if>
		</xsl:if>
		
	    <xsl:if test="$type = 'CONTENT' and not($deactivateFOEditionToolbar = 'true')">       
    	    <xsl:choose>
    	    <xsl:when test="$zone-name = 'aside'">
    	          <!-- Small version of toolbar -->
    	          <xsl:call-template name="ametys-front-edition-content-toolbar">
    	            <xsl:with-param name="content-id" select="$content-id"/>
    	            <xsl:with-param name="zone-name" select="$zone-name"/>
    	            <xsl:with-param name="zone-item-id" select="@id"/>
    	            <xsl:with-param name="edit-view-name">edition-fo</xsl:with-param>
    	            <xsl:with-param name="items">['edit', 'current-step', {type: 'menu', hideLabel: true, label: '<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_MORE_MENU_LABEL" i18n:catalogue="plugin.front-edition"/>', icon: 'fas fa-ellipsis-v', items: ['workflow-action-3', 'workflow-action-4', 'workflow-action-7', 'workflow-action-10', 'tag', 'move', 'remove']}]</xsl:with-param>
    	          </xsl:call-template>
    	      </xsl:when>
    	      <xsl:when test="$zone-name = 'default'">
    	          <!-- Default toolbar for default zone -->
    	          <xsl:call-template name="ametys-front-edition-content-toolbar">
    	            <xsl:with-param name="content-id" select="$content-id"/>
    	            <xsl:with-param name="zone-name" select="$zone-name"/>
    	            <xsl:with-param name="zone-item-id" select="@id"/>
    	            <xsl:with-param name="edit-view-name">edition-fo</xsl:with-param>
    	            <xsl:with-param name="workflow-actions">[3, 4, 7, 10]</xsl:with-param>
    	            <xsl:with-param name="items">['edit', 'status-history', 'current-step', {type: 'menu', items: ['workflow-action-3',  'workflow-action-4', 'workflow-action-7']},  'workflow-action-10',  {type: 'menu', label: '<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_MORE_MENU_LABEL" i18n:catalogue="plugin.front-edition"/>', items: ['tag', 'move', 'remove']}]</xsl:with-param>
    	          </xsl:call-template>
    	      </xsl:when>
	       </xsl:choose> 
	  </xsl:if>

     </xsl:template>
    
</xsl:stylesheet>