<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">zone-qui-fait-quoi</xsl:variable>

    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for  "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/qui-fait-quoi/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="additionnal-link"/>
    
    <!-- Override to add  aria-label -->
    <xsl:template name="form-criteria">    
        <xsl:call-template name="js-sumit-bo"/>
        <form method="post" class="search" role="search" aria-label="skin.{$skin}:SKIN_SERVICE_SEARCH_DIRECTORY_FORM_LABEL" i18n:attr="aria-label">
            <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
            <div>
                <xsl:call-template name="form-search"/>
            </div>
        </form>
    </xsl:template>
    
    <!-- Overriden to change CSS class names  -->
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
            <div>
                <xsl:attribute name="class">
                    <xsl:choose>
                        <xsl:when test="enumeration">form-group form-select</xsl:when>
                        <xsl:otherwise>form-group</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                
                <xsl:apply-templates select="." mode="field-label">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
                
                <xsl:apply-templates select="." mode="field-input">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </div>
    </xsl:template>
    
    <!-- Override to allow placeholder -->
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" class="text">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <!--  Overriden for sr-only -->
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label for="{$id}" class="sr-only"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DIRECTORY_FULLTEXT_PLACEHODER" i18n:catalogue="skin.{$skin}"/></label>
    </xsl:template>
    
    <!--  Overriden for sr-only -->
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label for="{$id}" class="sr-only"><xsl:value-of select="label"/></label>
    </xsl:template>
    
    <!-- Overriden to add 'fa-caret-down' icon  -->
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <select id="{$id}" name="{@name}" class="form-control">
            <xsl:apply-templates select="." mode="criterion-enumeration-select"/>
            
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="criterion-enumeration-all-option"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </select>
        <i class="fas fa-caret-down" aria-hidden="true"></i>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input-placeholder">
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
        <option value="" selected="" disabled="" hidden=""><xsl:value-of select="label"/></option>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_DIRECTORY_FULLTEXT_PLACEHODER</xsl:attribute>
        <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_DIRECTORY_FULLTEXT_PLACEHODER</xsl:attribute>
        <xsl:attribute name="i18n:attr">placeholder title</xsl:attribute>
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <!-- Overriden to change HTML of button -->
    <xsl:template name="common-utils-input-submit">
        <xsl:param name="class-name"/>
        <xsl:param name="text"/>
        <xsl:param name="i18nkey"/>
        <xsl:param name="name"/>   
        <xsl:param name="i18ntitle"/>  
        <xsl:param name="title"/>             
        <xsl:param name="id"/>        
        <xsl:param name="onclick"/>        
        <xsl:param name="width"/>        
        <xsl:param name="type">submit</xsl:param>        
        <xsl:param name="disabled" select="false()"/>        
        
            <button type="{$type}">
                <xsl:choose>
                <!-- i18n key -->
                    <xsl:when test="$i18nkey != ''">
                        <xsl:attribute name="value"><xsl:value-of select="$i18nkey"/></xsl:attribute>
                        <xsl:attribute name="i18n:attr">value</xsl:attribute>
                    </xsl:when>
                <!-- text value -->
                    <xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$text"/></xsl:attribute></xsl:otherwise>                
                </xsl:choose>
                
                <xsl:attribute name="class">focus-reversed <xsl:value-of select="$class-name"/></xsl:attribute>
                <xsl:if test="$name != ''">
                    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$id != ''">
                    <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$onclick">
                    <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$disabled">
                    <xsl:attribute name="disabled">disabled</xsl:attribute>
                </xsl:if>
                <xsl:if test="$width != ''">
                    <xsl:attribute name="style">width: <xsl:value-of select="$width"/>px;</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$i18ntitle != ''">
                        <xsl:attribute name="title"><xsl:value-of select="$i18ntitle"/></xsl:attribute>
                        <xsl:attribute name="i18n:attr">title<xsl:if test="$i18nkey != ''"> value</xsl:if></xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise><xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute></xsl:otherwise>                
                </xsl:choose>
                
                <i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_BUTTON" i18n:catalogue="skin.{$skin}"/>
            </button>
    </xsl:template>
</xsl:stylesheet>