<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
		exclude-result-prefixes="ametys">
	
    <xsl:import href="plugin:web://pages/services/sitemap/sitemap_3.3.xsl"/>	
    
    <xsl:variable name="common-service-css-class-name">ametys-sitemap-collapse </xsl:variable>		
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/sitemap-collapse/scss/main.css')}" media="screen, print"/>  
    </xsl:template>
    
    <xsl:template name="common-service-head-js"/>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="page-list"/>
        
        <xsl:call-template name="sitemap-js"/>
    </xsl:template>     
    
    <xsl:template name="page-list">
        <xsl:if test="/sitemap/page">
            <nav role="navigation">
                <ul id="{$id}" class="first">
                    <xsl:apply-templates select="/sitemap/page"/>
                </ul>
            </nav>
        </xsl:if>    
    </xsl:template>
    
	<xsl:template match="page">
        <xsl:param name="level">2</xsl:param>
        <li>
            <xsl:if test="page"><xsl:attribute name="class">has-submenu</xsl:attribute></xsl:if>
            <a href="{resolver:resolve('page', @id)}" title="{@long-title}">
                <xsl:value-of select="@title" />
                <xsl:if test="page">
                    <xsl:call-template name="sitemap-icon" />
                </xsl:if>
            </a>
            <xsl:if test="page">
                <ul class="level-{$level}">
                    <xsl:apply-templates select="page">
                        <xsl:with-param name="level" select="$level +1"></xsl:with-param>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
	
	<xsl:template name="sitemap-icon">
	   <button class="chevron" type="button" aria-label="{@title}">
         <svg aria-hidden="true" width="11.2535094px" height="7.26635041px" viewBox="0 0 11.2535094 7.26635041" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
			<g stroke="none" stroke-width="1" fill="none"
				fill-rule="evenodd">
				<g id="Produit-interieur-colonne-droite"
					transform="translate(-1468.748232, -594.617059)" fill="#1ABC9C"
					fill-rule="nonzero">
					<g id="menu-secondaire"
						transform="translate(1011.000000, 306.000000)">
						<g id="chevron" transform="translate(457.748232, 288.617059)">
							<path d="M6.22440952,0.247425266 C5.89392783,-0.083056429 5.35958157,-0.083056429 5.02909987,0.25092715 L0.247861271,5.03216575 C-0.0826204237,5.35911123 -0.0826204237,5.89349182 0.247861271,6.22397352 L1.04591311,7.01848914 C1.37285859,7.34897083 1.90723918,7.34897083 2.23768654,7.01848914 L5.6267547,3.62945532 L9.01932473,7.01498726 C9.34627021,7.34543462 9.8806508,7.34543462 10.2111325,7.01498726 L11.0056481,6.2204373 C11.3361298,5.89349182 11.3361298,5.35911123 11.0056481,5.02866387 L6.22440952,0.247425266 Z"></path>
						</g>
					</g>
				</g>
			</g>
		</svg>
       </button>
	</xsl:template>
	
	<xsl:template name="sitemap-js">
	   <script>
            $j(".ametys-sitemap-collapse .has-submenu .chevron").on('click', function (e) {
                e.preventDefault();
                var $parent = $j(this).closest(".has-submenu");
                if ($parent.hasClass("open")) {
                    // close
                    $parent.removeClass("open");
                    $parent.find(">ul").hide();
                    $j(this).attr("aria-expanded", false);
                } else {
                    // Open
                    $parent.addClass("open");
                    $parent.find(">ul").show();
                    $j(this).attr("aria-expanded", true);
                }
                 
                
                // scroll to the click
                $j("html, body").animate(
                   {
                      scrollTop: $j(this).offset().top - 200,
                    },
                   500
                );
            });
          </script>
        </xsl:template>
		
</xsl:stylesheet>		
