<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
                
    <xsl:import href="plugin:ugc://pages/services/ugc/form.xsl"/>
    
    <!-- Used by common -->
	<xsl:template name="common-service-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/ressource_file.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
	</xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function() {
                var $input = $j('.ugc form .field input:not([type="checkbox"])');
                $input.each(function() {
                    var $this = $j(this),
                        $label = $this.closest('.field').find('.label'),
                        label = $label.find('label').text();
                        
                    $this.attr('placeholder', label);
                    $this.attr('title', label);
                    $label.addClass("sr-only");
                })
                
                var $select = $j('.ugc form .field select');
                $select.each(function() {
                    var $this = $j(this),
                        $label = $this.closest('.field').find('.label'),
                        label = $label.find('label').text();
                        
                    $this.attr('placeholder', label);
                    $this.attr('title', label);
                    $label.addClass("sr-only");
                })
                
                var $textarea = $j('.ugc form .field textarea');
                $textarea.each(function() {
                    var $this = $j(this),
                        $label = $this.closest('.field').find('.label'),
                        label = $label.find('label').text();
                        
                    $this.attr('placeholder', label);
                    $this.attr('title', label);
                    $label.addClass("sr-only");
                })
                
                var $category = $j("select[name='category']");
                var opt = $category.find("option[value='']");
                opt.text("- <i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_CATEGORY" i18n:catalogue="plugin.classified-ads"/> -");
            });
        </script>
        
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/ugc/mixin/view|/ugc/content-type/view"/>
        </xsl:call-template>
        
    </xsl:template>
    
    <xsl:template name="gtu-field">
        <xsl:param name="gtu-mode"/>
        <xsl:param name="gtu-page-id"/>
        <xsl:param name="gtu-link-label"/>
        
        <div id="field-gtu-{$uniqueId}" class="field field-checkbox field-gtu">
             <xsl:call-template name="gtu-field-label"/>
             
             <xsl:call-template name="gtu-field-input"/>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="gtu-field-input">
        <div class="input input-checkbox" id="input-gtu-{$uniqueId}">
            <input type="checkbox" name="gtu" id="gtu-{$uniqueId}" value="true">
                <xsl:attribute name="data-ametys-mandatory">true</xsl:attribute>
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </input>
        </div>
    </xsl:template>

</xsl:stylesheet>