<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                exclude-result-prefixes="docbook"
                extension-element-prefixes="resolver ametys user math">
                
    <xsl:import href="plugin:user-directory://pages/services/organization-chart/organization-chart_4.5.xsl"/>   
    
    <xsl:variable name="common-service-css-class-name">organization-chart ametys-zone-organigramme</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/organization-chart/scss/main.css')}"/>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/orgunit/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="organization-chart-js"/>
    	
		<!-- TOOLTIP -->
	    <script src="{ametys:skinURL('plugins/js/popper.min.js')}"></script>
	    <script src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}"></script>
		
		<script>
            // Tippy plugin to hide tooltip on ESC
            const hideOnEsc = {
              name: 'hideOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
		    $j(document).ready(function () {
	            tippy('[data-tippy-content]', {plugins: [hideOnEsc]});
	        });
	        
	        $j(document).on('click', '.annuary-item', function (e) {
	            const hasPreventDefault = e.target.getAttribute("data-prevent-default");
	
	            if (hasPreventDefault !== true) {
	                const link = $j(this).find('a:first').attr('href');
	            }
	        });
	    </script>
	</xsl:template>
    
</xsl:stylesheet>
