<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver"
                exclude-result-prefixes="ametys">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>
    
    <!-- Override to set title on input field -->
    <xsl:template match="/">
        <html>
            <head>
                <title><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></title>
                <script type="text/javascript">
                    $j(document).ready(function() {
                        $j('.login-part form .login-input-wrapper input:not([type=checkbox])').each(function(i, input) {
                            var label = $j(input).closest('.login-input-wrapper').find('.label label').text();
                            if (label)
                            {
                                $j(input).attr('placeholder', label);
                                $j(input).attr('title', label);
                            }
                        })
                        
                        $j('.login-part form .login-input-wrapper select').each(function(i, input) {
                            var label = $j(input).closest('.login-input-wrapper').find('.label label').text();
                            if (label)
                            {
                                $j(input).attr('title', label);
                            }
                        })
                     });
                </script>
            </head>
            <body id="default">
                <xsl:call-template name="body"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="body-title"/>
    
    <xsl:template name="login">
        <xsl:call-template name="login-user-populations-standalone"/>
        
        <xsl:call-template name="login-credential-providers"/>
    </xsl:template>
    
    <xsl:template name="login-title">
        <h1 class="ametys-richtext-title-1"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></h1>
    </xsl:template> 
    
    <xsl:template name="body-existingaccount-title">
        <h1 class="ametys-richtext-title-1"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></h1>
    </xsl:template>
    
    <xsl:template name="signup"/>
    
    
    
</xsl:stylesheet>
