<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="skin://services/web/pages/services/search/search-carousel.xsl"/>         
    
    <xsl:variable name="common-service-css-class-name">ametys-service-actu-grid</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
        
        <h1 class="service-title"><xsl:value-of select="$title"/></h1>
   </xsl:template>
   
   <xsl:template name="common-service-head-js">
         <xsl:call-template name="search-service-head-js"/>
         
        <script type="text/javascript">
            $j(document).ready(function(){
                $j('#search-form-<xsl:value-of select="$uniqueId"/> .select-association').on('change', function() {
                     $j("#search-form-<xsl:value-of select="$uniqueId"/> button[data-search]").click()
                });
            })
            
            function callbackForm(){};
        </script>
    </xsl:template>
    
    <xsl:template name="hits">
        <ul data-ametys-search-role="hits" class="actus">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </ul>
    </xsl:template> 
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
    <xsl:template name="hit-attributes"/>
    
</xsl:stylesheet>