<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-webtv </xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
    	<!-- BEGIN head-css-slick-carousel -->
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick.css')}" type="text/css" />
	    <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/slick-theme.css')}" type="text/css" />
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/slick/accessible-slick-theme.css')}" type="text/css" />
    	<!-- END head-css-slick-carousel -->
    	
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/print.css')}"/>
    </xsl:template>
    
     <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
         
		<script type="text/javascript" src="{ametys:skinURL('plugins/slick/slick.js')}"></script>
		<script type="text/javascript">
		    function loadCarousel<xsl:value-of select="$uniqueId"/>()
            {
                $j('.ametys-zone-webtv .webtv-grid').slick({
                regionLabel: "<i18n:text i18n:key="SKIN_MEDIAS_REGION_LABEL" i18n:catalogue="skin.{$skin}"/>",
                infinite: false,
                dots: true,
                arrows: false,
                slidesToShow: 5,
                slidesToScroll: 5,
                ametysDotsBtnPrefixLabel : "<i18n:text i18n:key="SKIN_MEDIAS_CAROUSEL_DOTS_PREFIX" i18n:catalogue="skin.{$skin}"/>",
                responsive: [
                    {
                      breakpoint: 1280,
                      settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4
                      }
                    },
                    {
                      breakpoint: 1024,
                      settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3
                      }
                    },
                    {
                      breakpoint: 790,
                      settings: {
                        slidesToShow: 2,
                        slidesToScroll: 2
                      }
                    },
                    {
                      breakpoint: 550,
                      settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                      }
                    }
                  ]
            })
          }
          
          $j(document).ready(function(){
              loadCarousel<xsl:value-of select="$uniqueId"/>();
		  })
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
          <div class="container">
            <div class="webtv-section">
              <xsl:call-template name="header"/>
              <xsl:call-template name="search-results"/>
            </div>
          </div>
        </div>
    </xsl:template>
    
    <!-- Override to avoid #nav anchor (FIXME CMS-11645). There is no criteria nor sorts in this view -->
    <!-- Keep this override for 4.7.x versions (unnecessary for 4.8.x) -->
    <xsl:template name="form-result"/>
    
    <xsl:template name="header">
        <div class="flex-title">
          <xsl:if test="/search/header/text()">
            <h1 class="service-title"><xsl:copy-of select="/search/header/text()"/></h1>
          </xsl:if>
            <div class="right">
                <xsl:call-template name="link"/> 
            </div>
        </div>      
   </xsl:template>
   
   <xsl:template name="link-attribute">
        <xsl:attribute name="class">btn</xsl:attribute>
        <i class="fas fa-arrow-right" aria-hidden="true"></i>
    </xsl:template> 
    
    <xsl:template name="hits">
        <div class="webtv-grid slick-carousel" data-ametys-search-role="hits">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
        
    </xsl:template>

    <xsl:template name="hit">
      <div>
        <xsl:apply-templates select="."/>
      </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>webtv-grid-item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="pagination"/>
    
</xsl:stylesheet>