<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:exslt="http://exslt.org/common"
							exclude-result-prefixes="ametys resolver">

	<xsl:import href="plugin:classified-ads://stylesheets/content/ads/ads-main.xsl"/>
	
	<xsl:template name="common-content-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.min.css')}"/>
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_gallery.css')}" />
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/static_service_one_click.css')}" />
	</xsl:template>
	
	<xsl:template name="common-content-head-js">
		<script type="text/javascript" src="{ametys:skinURL('plugins/simple-lightbox/simple-lightbox.jquery.min.js')}"></script>
		<script type="text/javascript">
	        $j(document).ready(function () {
	            $j('.ametys-zone-gallery a').simpleLightbox();
	        });
	    </script>	
	</xsl:template>
	
	<xsl:template name="common-content-body-title">
		<xsl:call-template name="ads-tag"/>
	    <xsl:call-template name="common-content-body-title-content"/>
    </xsl:template>
	
	<xsl:template name="common-content-body-content">
  			<xsl:if test="not($zone = 'default' and $template = 'page')">
	            <!-- Image -->
	            <xsl:call-template name="common-content-body-image-bigsize">
	            	<xsl:with-param name="image" select="metadata/illustration/image1"/>
                    <xsl:with-param name="alternative" select="metadata/illustrations/image1/alt-text"/>
	            	<xsl:with-param name="maxWidth" select="'720'"/>
	            	<xsl:with-param name="maxHeight" select="'480'"/>
	            </xsl:call-template>  
	        </xsl:if>
            
            <!-- Info -->
            <xsl:call-template name="ads-info" />
	        
	        <!-- Phone -->
	        <xsl:call-template name="ads-phone"/>
	         
	        <!-- Mail -->
	        <xsl:call-template name="ads-mail"/>
            
            <!-- Price -->
            <xsl:call-template name="ads-price"/>
	        
            <!-- Rich content -->
            <xsl:call-template name="common-content-body-content-rich"/>
            
            <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
            
            <!-- Images -->
        	<xsl:call-template name="ads-photos" />
            
            <!-- Contact, Publish date... -->
            <xsl:call-template name="common-content-body-meta"/>
     
	        <!-- Comments -->
	        <xsl:call-template name="common-content-body-comments"/>
    </xsl:template> 
    
    <xsl:template name="ads-tag">
    	<xsl:if test="not($zone = 'default' and $template = 'ugc-page')">
			<div class="etiquette">
	            <xsl:value-of select="metadata/category/@title"/>
	        </div>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-info">
   		<xsl:call-template name="ads-contact"/>
        <xsl:call-template name="ads-location"/>
    </xsl:template>
    
    <xsl:template name="ads-contact">
   		<xsl:if test="metadata/firstname != '' or metadata/lastname != ''">
   			<div class="flex-icon">
   				<span class="material-icons">person</span>
       			<xsl:if  test="metadata/firstname != ''">
       				<xsl:value-of select="metadata/firstname"/>
       			</xsl:if>
       			<xsl:if test="metadata/firstname != '' and metadata/lastname != ''">
	        		<xsl:text> </xsl:text>
	        	</xsl:if>
	        	<xsl:if  test="metadata/lastname != ''">
	        		<xsl:value-of select="metadata/lastname"/>
	        	</xsl:if>
	        </div>
	    </xsl:if>
    </xsl:template>
        	
    <xsl:template name="ads-location">
        <xsl:if test="metadata/location" >
	        <div class="flex-icon">
	            <span class="material-icons">location_on</span><xsl:value-of select="metadata/location"/>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-phone">
    	<xsl:if test="metadata/phone" >
	        <div class="flex-icon">
	            <span class="material-icons">call</span>
	             <a href="tel:{metadata/phone}"><xsl:value-of select="metadata/phone"/></a>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-mail">
   		<xsl:if test="metadata/mail">
   			<div class="flex-icon">
    			<span class="material-icons">email</span>
    			 <a href="mailto:{metadata/email}"><xsl:value-of select="metadata/mail"/></a>
    		</div>
   		</xsl:if>
	</xsl:template>
    
    <xsl:template name="ads-price">
    	<xsl:if test="metadata/price != '' and metadata/price != '0.0'">
   			<div class="flex-icon">
    			<span class="material-icons">payment</span>
				<xsl:choose>
                    <xsl:when test="contains(metadata/price, '.0')"><xsl:value-of select="substring-before(metadata/price, '.0')"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="translate(metadata/price, '.', ',')"/></xsl:otherwise>
                </xsl:choose>
                <xsl:text> </xsl:text>
				<i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_PRICE_UNIT" i18n:catalogue="skin.{$skin}"/>
    		</div>
   		</xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-photos">
        <xsl:if test="metadata/illustrations/image1 or metadata/illustrations/image2">
        
            <div class="ametys-cms-service ametys-zone-gallery">
               <xsl:if test="metadata/illustrations/image1">
                   <xsl:call-template name="photo">
                        <xsl:with-param name="image" select="metadata/illustrations/image1"/>
                        <xsl:with-param name="maxWidth" select="'340'"/>
                        <xsl:with-param name="class">invisible</xsl:with-param>
                   </xsl:call-template>
               </xsl:if>
               <xsl:if test="metadata/illustrations/image2">
                   <xsl:call-template name="photo">
                        <xsl:with-param name="image" select="metadata/illustrations/image2"/>
                        <xsl:with-param name="maxWidth" select="'340'"/>
                   </xsl:call-template>
             </xsl:if>
             <xsl:if test="metadata/illustrations/image3">
                   <xsl:call-template name="photo">
                        <xsl:with-param name="image" select="metadata/illustrations/image3"/>
                        <xsl:with-param name="maxWidth" select="'340'"/>
                   </xsl:call-template>
             </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="photo">
        <xsl:param name="image" />
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        
        <a href="{resolver:resolve($image/@type, $image/@uri)}"  class="{$class}" title="{$image/@filename}">
            <xsl:if test="$rendering-context = 'back'">
                <xsl:attribute name="internal">internal</xsl:attribute>
            </xsl:if>
            
            <img src="{resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)}"/>
        </a>
    </xsl:template>
    
</xsl:stylesheet>
