<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:docbook="http://docbook.org/ns/docbook"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="plugin:multimedia://stylesheets/content/audio/audio-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-media.xsl" />
    
    <xsl:template name="ctype-icon">
        <i class="fas fa-podcast" aria-hidden="true"></i>
    </xsl:template>
    
    <xsl:template name="content-open-media-attributes">
        <xsl:attribute name="href">#player-<xsl:value-of select="$uniqueId"/></xsl:attribute>
        <xsl:attribute name="id">audio-link-<xsl:value-of select="$uniqueId"/></xsl:attribute>
        <xsl:attribute name="data-fancybox"></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-open-media-js">
        <div class="ametys-video__modal">
            <audio id="player-{$uniqueId}" class="ametys-audio__modal_frame"></audio>
        </div>
        <script type="text/javascript">
              var audioPlayer<xsl:value-of select="$uniqueId"/>;

              $j(document).ready(function() {
                $j("#audio-link-<xsl:value-of select="$uniqueId"/>").fancybox({
                  beforeShow: function(){
                    audioPlayer<xsl:value-of select="$uniqueId"/> = new MediaElementPlayer('player-<xsl:value-of select="$uniqueId"/>', {
                      alwaysShowControls: true,
                      success: function(media) {
                        media.setSrc("<xsl:value-of select="resolver:resolve(metadata/file/@type, metadata/file/@path, 'true')"/>");
                        media.load();
                      }
                    });
                  },
                  afterShow: function() {
                    $j($j('#player-<xsl:value-of select="$uniqueId"/>')[0]).find('audio').prop("controls", true)
                    $j('#player-<xsl:value-of select="$uniqueId"/>')[0].play();
                  },
                  beforeClose: function (){ 
                    audioPlayer<xsl:value-of select="$uniqueId"/>.cleartracks();
                    audioPlayer<xsl:value-of select="$uniqueId"/>.remove();
                  }
                });
              });
        </script> 
    </xsl:template>
    
</xsl:stylesheet>