<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="ametys docbook"
                              extension-element-prefixes="resolver user">

    <xsl:import href="plugin:user-directory://stylesheets/content/udorgunit/udorgunit-main.xsl"/>
    
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/orgunit/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
		<!-- TOOLTIP -->
	    <script src="{ametys:skinURL('plugins/js/popper.min.js')}"></script>
	    <script src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}"></script>
		
		<script>
            // Tippy plugin to hide tooltip on ESC
            const hideOnEsc = {
              name: 'hideOnEsc',
              defaultValue: true,
              fn({hide}) {
                function onKeyDown(event) {
                  if (event.keyCode === 27) {
                    hide();
                  }
                }
                return {
                  onShow() {
                    document.addEventListener('keydown', onKeyDown);
                  },
                  onHide() {
                    document.removeEventListener('keydown', onKeyDown);
                  },
                };
              },
            };
            
		    $j(document).ready(function () {
	            tippy('[data-tippy-content]', {plugins: [hideOnEsc]});
	        });
	        
	        $j(document).on('click', '.annuary-item', function (e) {
	            const hasPreventDefault = e.target.getAttribute("data-prevent-default");
	
	            if (hasPreventDefault !== true) {
	                const link = $j(this).find('a:first').attr('href');
	            }
	        });
	    </script>
	</xsl:template>
    
    <xsl:template name="common-content-body-title-content"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:if test="not(ametys:pageId())">
            <h1 class="ametys-richtext-title-1"><xsl:value-of select="metadata/title"/></h1>
        </xsl:if>
        
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="not(ametys:pageId())">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>   
            
        <xsl:call-template name="main-users">
            <xsl:with-param name="truelevel" select="$truelevel"/>
            <xsl:with-param name="metadataSetName" select="'abstract'"/>
        </xsl:call-template>    
        
        <xsl:call-template name="orgUnit-presentation" />
        
        <xsl:call-template name="child-orgUnits">
             <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        <xsl:call-template name="other-users">
             <xsl:with-param name="truelevel" select="$truelevel"/>
             <xsl:with-param name="metadataSetName" select="'abstract'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="main-users-list" >
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
            <xsl:for-each select="//users/user[@role and @metadataSetName=$metadataSetName]">
                 <xsl:call-template name="main-user">
                     <xsl:with-param name="truelevel" select="$truelevel"/>
                 </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="main-user">
        <xsl:param name="truelevel"/>
        
        <div class="main-user">
            <span class="role"><xsl:value-of select="@role"/></span>
            <xsl:call-template name="main-user-content">
                <xsl:with-param name="content" select="content"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="main-user-content">
        <xsl:param name="content"/>
        <xsl:param name="level">3</xsl:param>
        
		<xsl:variable name="page-id">
        	<xsl:call-template name="get-page-id">
        		<xsl:with-param name="id" select="$content/@id"/>
        	</xsl:call-template>
        </xsl:variable>
        
        <section>
	        <div class="user-picture">
	        	<a href="{resolver:resolve('page', $page-id, false)}" aria-hidden="true" tabindex="-1">
        			<xsl:call-template name="user-image">
        				<xsl:with-param name="content" select="$content"/>
        			</xsl:call-template>
	        	</a>
	        </div>
	        <div class="user-infos">
	        	<a href="{resolver:resolve('page', $page-id, false)}">
	        		<xsl:call-template name="main-user-title">
        				<xsl:with-param name="content" select="$content"/>
        			</xsl:call-template>
	        	</a>
	        	<xsl:call-template name="main-user-function">
       				<xsl:with-param name="content" select="$content"/>
       			</xsl:call-template>
	        	<xsl:call-template name="main-user-phone">
       				<xsl:with-param name="content" select="$content"/>
       			</xsl:call-template>
	        	<xsl:call-template name="main-user-email">
       				<xsl:with-param name="content" select="$content"/>
       			</xsl:call-template>
	       	</div>
	    </section>
    </xsl:template>
    
    <xsl:template name="get-page-id">
    	<xsl:param name="id"/>
    	
        <xsl:value-of select="user:getUserPage($id)"/>
    </xsl:template>
    
    <xsl:template name="main-user-title">
    	<xsl:param name="content"/>
    	<xsl:variable name="main-user-title" select="$content/html/head/meta[@name = 'title']/@content"/>
    	
    	<xsl:if test="$main-user-title != ''">
       		<span class="name"><xsl:value-of select="$main-user-title"/></span>
       	</xsl:if>
    </xsl:template>
    
    <xsl:template name="main-user-function">
    	<xsl:param name="content"/>
    	<xsl:variable name="main-user-function" select="$content/html/head/meta[@name = 'function']/@content"/>
    	
	    <xsl:if test="$main-user-function != ''">
       		<span class="function"><xsl:value-of select="$main-user-function"/></span>
       	</xsl:if>
    </xsl:template>
    
    <xsl:template name="main-user-phone">
    	<xsl:param name="content"/>
    	<xsl:variable name="main-user-phone" select="$content/html/head/meta[@name = 'phone']/@content"/>
    	
	    <xsl:if test="$main-user-phone != ''">
	       	<a href="tel:{$main-user-phone}" data-prevent-default="true" class="flex">
	       		<i data-prevent-default="true" class="fas fa-phone"></i>
	       		<span data-prevent-default="true" class="phone"><xsl:value-of select="$main-user-phone"/></span>
      		</a>
       </xsl:if>
   </xsl:template>
   
   <xsl:template name="main-user-email">
   	    <xsl:param name="content"/>
        <xsl:variable name="main-user-email" select="$content/html/head/meta[@name = 'email']/@content"/>
   		
        <xsl:if test="$main-user-email != ''">
      		<a href="mailto:{$main-user-email}" data-tippy-content="{$main-user-email}" data-prevent-default="true" class="flex">
      			<span data-prevent-default="true" class="icon fas fa-envelope" aria-hidden="true"></span>
      			<span data-prevent-default="true" class="email"><xsl:value-of select="$main-user-email"/></span>
 			</a>
		</xsl:if>
  	</xsl:template>
    
    <xsl:template name="user-image">
    	<xsl:param name="content"/>
    	
    	<xsl:variable name="main-user-login" select="$content/html/head/meta[@name = 'user;login']/@content"/>
        <xsl:variable name="main-user-population" select="$content/html/head/meta[@name = 'user;populationId']/@content"/>
    	<xsl:variable name="user-image-type" select="$content/html/head/meta[@name = 'illustration/image;type']/@content"/>     
  		<xsl:variable name="user-image-url"><xsl:value-of select="$content/html/head/meta[@name = 'illustration/image;uri']/@content"/></xsl:variable>
        
        <div class="picture">
            <xsl:choose>
                <xsl:when test="$user-image-type != '' and $user-image-url != ''">
                    <img alt="" src="{resolver:resolveCroppedImage($user-image-type, $user-image-url, 81, 81)}" />
                </xsl:when>
                <xsl:when test="$content/html/head/meta[@name = 'user']">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">81</xsl:with-param>
                        <xsl:with-param name="login" select="$main-user-login"/>
                        <xsl:with-param name="population" select="$main-user-population"/>
                        <xsl:with-param name="lang" select="$content/@language"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="user-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="user-default-image">
        <img src="{ametys:skinURL('templates/common/img/avatar.png')}" width="81"/>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-title">
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <xsl:attribute name="class">ametys-richtext-title-<xsl:value-of select="$truelevel"/></xsl:attribute>
            <i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-list">
        <xsl:param name="truelevel"/>
        <ul class="child-orgUnits-list">
            <xsl:for-each select="//orgUnits/orgUnit">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="other-users-title" >
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <xsl:attribute name="class">ametys-richtext-title-<xsl:value-of select="$truelevel"/></xsl:attribute>
           <i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_USERS_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="other-users-list" >
        <xsl:param name="truelevel"/>
        <xsl:param name="metadataSetName"/>
                
        <div class="other-users-container">
            <xsl:for-each select="//users/user[not(@role) and @metadataSetName=$metadataSetName]">
                <xsl:call-template name="content">
                    <xsl:with-param name="content" select="content"/>
                    <xsl:with-param name="level" select="$truelevel + 1"/>
                </xsl:call-template>
            </xsl:for-each>
        </div>
    </xsl:template>
</xsl:stylesheet>