<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="skin://stylesheets/variables.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="footer">
    	<footer class="footer" role="contentinfo">
	        <div class="footer-container">
	            <div class="column column-white">
	                <xsl:call-template name="logo_footer"/>
	                
	                <xsl:call-template name="footer_contact_infos"/>
	                
					<xsl:call-template name="social"/>
	            </div>
	            
	            <xsl:call-template name="meteo_footer"/>
	            
	            <xsl:call-template name="others_footer_links"/>
	             
	        </div>
	    </footer>
    </xsl:template>
    
    <xsl:template name="logo_footer">
        <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo"><img src="{ametys:skinURL('templates/common/img/logo-footer.png')}" alt="Ametys"/></a>
    </xsl:template>
    
    <xsl:template name="footer_contact_infos">
        <ul class="list-icon">
            <li><a href="tel:0562191900"><i class="fas fa-phone" aria-hidden="true"></i> 05 62 19 19 00</a></li>
            <li><a href="mailto:ametys.org"><i class="fas fa-envelope" aria-hidden="true"></i> ametys.org</a></li>
            <li><a href="https://www.ametys.org" target="_blank"><i class="fas fa-globe" aria-hidden="true"></i> ametys.org </a></li>
        </ul>
    </xsl:template>
    
    <xsl:template name="others_footer_links">
        <xsl:variable name="liens_utiles" select="ametys:findPagesIdsByTag('LIENS_UTILES')"/>
       
        <div class="column links-column">
           <ul>
               <li><h2 class="title"><i18n:text i18n:key="SKIN_FOOTER_MENU_RAPIDE_TITLE" i18n:catalogue="skin.{$skin}"/></h2></li>
	           <xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
	               <li><a href="{resolver:resolve('page', @sitemap:id)}"><xsl:value-of select="@sitemap:title" /></a></li>
	           </xsl:for-each>
           </ul>
        </div>
        <xsl:if test="$liens_utiles">
            <div class="column links-column">
                <ul>
                   <li><h2 class="title"><i18n:text i18n:key="SKIN_FOOTER_LIEN_UTILES_TITLE" i18n:catalogue="skin.{$skin}"/></h2></li>
                   <xsl:for-each select="$liens_utiles">
                        <li>
                            <a href="{resolver:resolve('page', @id)}">
                                <xsl:if test="ametys:pageUrlType(@id) = 'WEB'">
                                    <xsl:call-template name="external-link-attributes">
                                        <xsl:with-param name="title" select="ametys:pageTitle(@id)"/>
                                    </xsl:call-template>
                                </xsl:if>
                                <span><xsl:value-of select="ametys:pageTitle(@id)" /></span>
                            </a>
                        </li>
                   </xsl:for-each>
                 </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="meteo_footer">
        <xsl:variable name="meteo-title"><xsl:call-template name="widget-meteo-title"/></xsl:variable>
        
        <xsl:variable name="i18nparams"><city><xsl:value-of select="$meteo-title"/></city></xsl:variable> 
        <xsl:variable name="i18nkey" select="concat('skin.', $skin, ':SKIN_FOOTER_METEO_WIDGET_TITLE')"/>
        <xsl:variable name="widget-title">
            <xsl:value-of select="ametys:translate($i18nkey, $lang, $i18nparams)"/>
        </xsl:variable>
                
        <div class="column meteo-column">
            <h2 class="title"><i18n:text i18n:key="SKIN_FOOTER_METEO_TITLE" i18n:catalogue="skin.{$skin}"/></h2>
            <div class="meteo-module">
             <a class="weatherwidget-io" data-label_1="{$meteo-title}" title="{$widget-title}" style="display: block; position: relative; height: 145px; padding: 0px; overflow: hidden; text-align: left; text-indent: -299rem;">
                <xsl:call-template name="widget-meteo-config"/>
                <xsl:call-template name="widget-meteo-href"/>
                
                <xsl:call-template name="widget-meteo-title"/>
             </a>
                <script>
                    ! function (d, s, id) {
                        var
                            js, fjs = d.getElementsByTagName(s)[0];
                        if (!d.getElementById(id)) {
                            js = d.createElement(s);
                            js.id = id;
                            js.src = 'https://weatherwidget.io/js/widget.min.js';
                            fjs.parentNode.insertBefore(js, fjs);
                        function updateIframe() { 
                            var iframe = $j("iframe.weatherwidget-io-frame").attr("title", "<i18n:text i18n:catalogue="skin.{$skin}" i18n:key="SKIN_FOOTER_METEO_IFRAME_TITLE"/>").removeAttr('frameborder').removeAttr('width');
                            if (iframe.length == 0)
                            {
                                window.setTimeout(updateIframe, 100);
                            }
                        }
                            updateIframe();
                        }
                    }(document, 'script', 'weatherwidget-io-js');
                </script>
            </div>
        </div>
    </xsl:template>
    
    
    <xsl:template name="widget-meteo-title">Paris, France</xsl:template>
    
    <xsl:template name="widget-meteo-config">
        <xsl:attribute name="data-mode">Current</xsl:attribute>
        <xsl:attribute name="data-font">Roboto</xsl:attribute>
        <xsl:attribute name="days">3</xsl:attribute>
        <xsl:attribute name="data"></xsl:attribute>
        <xsl:attribute name="data-textcolor">#fff</xsl:attribute>
        <xsl:attribute name="data-suncolor">#fff</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="widget-meteo-href">
        <xsl:attribute name="href">https://forecast7.com/fr/48d862d35/paris/</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="social">
        <xsl:if test="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link">
            <h2 class="title">Restez connectés</h2>
            <ul class="social">
                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='socialNetworks']/links/link[not(@disabled)]" mode="social-link">
                   <xsl:with-param name="uniqueId" select="$uniqueId"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="link" mode="social-link">
        <li>
            <a href="{@url}" target="_blank" title="{@title}">
                <xsl:choose>
                    <xsl:when test="@pictureType = ''">
                        <!-- No picture -->
                        <span class="link-text"><xsl:value-of select="@title"/></span>
                    </xsl:when>
                    <xsl:when test="@pictureType = 'glyph'">
                        <span class="picture link-glyph {@pictureGlyph}" role="img" aria-label="{@title}"></span>
                    </xsl:when>
                    <xsl:otherwise>
                         <xsl:variable name="imgId">
                            <xsl:choose>
                                <xsl:when test="@pictureType = 'resource'">
                                    <xsl:value-of select="@pictureId" />
                                </xsl:when>
                                <xsl:when test="@pictureType = 'external'">
                                    <xsl:value-of select="concat(@picturePath, '?objectId=', @id)" />
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                        <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $imgId, 0, 0)}">
                            <xsl:attribute name="alt">
                                <xsl:choose>
                                    <xsl:when test="@pictureAlternative != ''"><xsl:value-of select="@pictureAlternative"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
                                </xsl:choose>        
                            </xsl:attribute>
                        </img>
                    </xsl:otherwise>
                </xsl:choose>
            </a>
        </li>
    </xsl:template>
		
    
    <xsl:template match="page" mode="footer-link">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:value-of select="@sitemap:title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="scroll-top">
        <button type="button" class="up" title="skin.{$skin}:SKIN_SCROLL_TO_TOP" i18n:attr="title">
	        <span class="fas fa-arrow-up" aria-hidden="true"></span>
	    </button>
	
	    <script>
	        $j(document).scroll(function () {
	            const scroll = $j(window).scrollTop();
	
	            if (scroll == 0) {
	                $j('.up').fadeOut();
	            } else {
	                $j('.up').fadeIn();
	            }
	        });
	
	        $j(".up").click(function () {
	           window.scrollTo({ top: 0, behavior: 'smooth' });
	        });
	    </script>
    </xsl:template>
    
</xsl:stylesheet>