<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:datetime="http://ametys.org/datetime/4.2" 
        					extension-element-prefixes="datetime" 
                            exclude-result-prefixes="sitemap resolver ametys exslt">

    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/variables.xsl" />
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/zones.xsl" />
    <xsl:import href="skin://stylesheets/menus.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl"/>
    <xsl:import href="skin://stylesheets/footer.xsl"/>
    <xsl:import href="skin://stylesheets/others.xsl"/>
    <xsl:import href="skin://stylesheets/search.xsl"/>
    
    <xsl:variable name="sitemap" select="/cms/inputData/sitemap" />
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')" />

    <!-- + | BASE + -->
    <xsl:template name="template">
        <html>
            <xsl:call-template name="head" />
            <xsl:call-template name="body" />
        </html>
    </xsl:template>
    
    <xsl:template name="body">
        <body>
        	<xsl:attribute name="class">
  				<xsl:if test="$rendering-context = 'back'"> back</xsl:if>
  			</xsl:attribute>
  			
  			<xsl:call-template name="accessibility-links"/>
  			
		    <xsl:call-template name="alertes"/>
		    
            <xsl:call-template name="header"/>
            
            <main role="main" id="main-content">
                <div class="background internal ">
                    <xsl:call-template name="body-background-image"/>
                    <xsl:call-template name="has-img"/>
                </div>
            
        		<xsl:call-template name="main-zone"/>
        		<xsl:call-template name="acces-rapides">
                    <xsl:with-param name="height">36</xsl:with-param>
                    <xsl:with-param name="width">36</xsl:with-param>
                </xsl:call-template>
            </main>
    		<xsl:call-template name="footer"/>
    		<xsl:call-template name="scroll-top"/>
        </body>
    </xsl:template>
    
      <xsl:template name="alertes">
       	<xsl:if test="/cms/inputData/Model/flashinfos/content">
            <div class="alert alert-dialog"  style="display: none;">
                <xsl:for-each select="/cms/inputData/Model/flashinfos/content">
                    <div class="flashinfo-content" data-flashinfo-id="{@id}@{@lastModifiedAt}">
                        <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                             <xsl:with-param name="level" select="3"/>
                         </xsl:apply-templates>
                    </div>
                </xsl:for-each>
               <button type="button" onclick="AmetysFlashInfo.showLater()"><i18n:text i18n:key="SKIN_FLASH_INFO_BANNER_SHOW_LATER" i18n:catalogue="skin.{$skin}" /></button>
               <button type="button" onclick="AmetysFlashInfo.markAsRead()"><i18n:text i18n:key="SKIN_FLASH_INFO_BANNER_MARK_READ" i18n:catalogue="skin.{$skin}" /></button>
            </div>
            <script type="text/javascript">
                function hideBanner() {
                    $j('.alert.alert-dialog').hide();
                    removeAlert();
                }
                
                function showBanner() {
                    $j('.alert.alert-dialog').show();
                    addAlert();
                }
                
                $j().ready(function() {
                    // Init and show flash info popup
                    AmetysFlashInfo.initialize(".alert.alert-dialog", showBanner, hideBanner, "<xsl:value-of select="ametys:siteUriPrefix()"/>");
                });
            </script>
        </xsl:if>
    
	</xsl:template>
    
    <xsl:template name="has-img"/>
    
    <xsl:template name="header-main-search">
         <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag('SEARCH')"/>
         
         <xsl:if test="$searchPage/@id">
         	<div class="search">
         		<form role="search" action="{resolver:resolve('page', $searchPage/@id)}" method="post" style="margin:0; padding: 0;" aria-label="skin.{$skin}:SKIN_MAIN_SEARCH_LABEL" i18n:attr="aria-label">
		            <i class="fas fa-search" aria-hidden="true"></i>
		            <input name="{$searchInputName}" class="ametys-header-search__control focus-reversed" type="text" title="skin.{$skin}:SKIN_MAIN_SEARCH" placeholder="skin.{$skin}:SKIN_MAIN_SEARCH" i18n:attr="placeholder title" />
		        </form>
		     </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-content"/>
    
    <xsl:template name="dates">
		<xsl:param name="startDate"/>
		<xsl:param name="endDate"/>
		
		<p class="content-date">
			<xsl:choose>
				<xsl:when test="$startDate and not($endDate)">
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
						<xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$endDate and not($startDate)">
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate and datetime:sameDate($startDate, $endDate)">
                    <!-- case when the two datetimes represent the same date -->
					<i18n:text i18n:key="CONTENT_NEWS_DATE" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$startDate and $endDate">
					<i18n:text i18n:key="CONTENT_NEWS_DATE_FROM" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$startDate"/>
                        <xsl:with-param name="role" select="'dtstart'"/>
					</xsl:call-template>
					<i18n:text i18n:key="CONTENT_NEWS_DATE_TO" i18n:catalogue="plugin.news"/>
					<xsl:call-template name="news-date-pattern">
						<xsl:with-param name="date" select="$endDate"/>
                        <xsl:with-param name="role" select="'dtend'"/>
					</xsl:call-template>
				</xsl:when>
				
			</xsl:choose>
		</p>
	</xsl:template>
	
	<xsl:template name="news-date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        
        <xsl:choose>
            <xsl:when test="$role = 'dtstart' or $role = 'dtend'">
                <abbr class="{$role}">
                    <span class="value-title" title="{$date}"></span>
                    <xsl:call-template name="common-utils-date-pattern">
                        <xsl:with-param name="date" select="$date"/>
                    </xsl:call-template>
                </abbr>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="common-utils-date-pattern">
                    <xsl:with-param name="date" select="$date"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- + 
	     | BREAD CRUMB
	     + -->
	<xsl:template name="bread-crumb">
		<nav class="breadcrumb" role="navigation" aria-label="skin.{$skin}:SKIN_BREADCRUMB_ARIA_LABEL" i18n:attr="aria-label">
			<a name="breadcrumb"></a>

			<ul>
				<xsl:if test="/cms/inputData/sitemap/page[@sitemap:name = 'index']">
					<li>
                        <xsl:attribute name="itemscope">itemscope</xsl:attribute>
                        <xsl:attribute name="itemtype">http://data-vocabulary.org/Breadcrumb</xsl:attribute>

                        <a href="{$site-uri-prefix}/{$lang}/index.html" itemprop="url">
                            <xsl:attribute name="itemprop">url</xsl:attribute>

                            <span itemprop="title">
                                <xsl:value-of select="/cms/inputData/sitemap/page[@sitemap:name = 'index']/@sitemap:title"/>
                            </span>
                        </a>
                    </li>
				</xsl:if>
                
                <xsl:apply-templates select="/cms/inputData/sitemap/page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']|/cms/inputData/sitemap/page[@sitemap:path = 'index']/page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
			</ul>
		</nav>
	</xsl:template>
    
    <xsl:template match="page" mode="breadcrumb">
        <li itemscope="itemscope" itemtype="http://data-vocabulary.org/Breadcrumb">
            <xsl:choose>
                <xsl:when test="not(@sitemap:current)">
                    <a href="{resolver:resolve('page', @sitemap:id)}" itemprop="url">
                        <span itemprop="title">
                            <xsl:value-of select="@sitemap:title" />
                        </span>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="aria-current">page</xsl:attribute>
                    <xsl:attribute name="class">active</xsl:attribute>
                    <a class="active" href="javascript:void(0)">
                        <span itemprop="title">
                            <xsl:value-of select="@sitemap:long-title" />
                        </span>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
        
        <xsl:apply-templates select="page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
    </xsl:template>

</xsl:stylesheet>
