<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
					
	<xsl:import href="plugin:link-directory://pages/services/directory/utils/inputdata_utils.xsl"/>
	<xsl:import href="skin://services/link-directory/pages/services/directory/utils/config_utils.xsl"/>
	
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
	<xsl:variable name="sectionInPath" select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false') and (@sitemap:in-path='true')]" />
							
    <xsl:template name="main-menu">
    	<xsl:param name="device">desktop</xsl:param>
            
    	<ul class="links desktop">
    		<!-- For each page with SECTION tag : page[@PLUGIN_TAGS_SECTION] -->
    		<xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
	            <li>
	            	<xsl:attribute name="class">
	            		<xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">has-submenu </xsl:if>
		            	<xsl:if test="@sitemap:in-path='true'"> active</xsl:if>
		            </xsl:attribute>
                    
	                <a href="{resolver:resolve('page', @sitemap:id)}">
                        <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                            <xsl:call-template name="external-link-attributes"/>
                        </xsl:if>
                        <xsl:choose>
                            <xsl:when test="@sitemap:current">
                                <xsl:attribute name="aria-current">page</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@sitemap:in-path='true'">
                                <xsl:attribute name="aria-current">true</xsl:attribute>
                            </xsl:when>
                        </xsl:choose>
	                	<xsl:value-of select="@sitemap:title" />
	            	</a>
                    
                    <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                        <button aria-label="{@sitemap:title}" aria-expanded="false" class="open-submenu-sr">
                                <i class="fas fa-angle-down" aria-hidden="true"></i>
                        </button>
                    </xsl:if>
                    
	            	<xsl:call-template name="submenu"/>
	            </li>
	        </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="submenu">
        <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
            <div class="submenu">
                <div class="levels">
                    <xsl:call-template name="submenu-levels"/>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="submenu-levels">
        <ul class="level list-lvl-one">
            <li class="title">
                <a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:value-of select="@sitemap:title" />
                </a>
            </li>
            
            <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-1"/>
        </ul>
    </xsl:template>
    
    <xsl:template match="page" mode="level-1">
        <li>
			<xsl:attribute name="class"><xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-submenu</xsl:if><xsl:if test="@sitemap:current or @sitemap:in-path='true'"> active</xsl:if></xsl:attribute>
            <div class="link">
        		<a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:in-path='true'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                    <xsl:choose>
                        <xsl:when test="@sitemap:current">
                            <xsl:attribute name="aria-current">page</xsl:attribute>
                        </xsl:when>
                        <xsl:when test="@sitemap:in-path='true'">
                            <xsl:attribute name="aria-current">true</xsl:attribute>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="className">external<xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                	<span><xsl:value-of select="@sitemap:title" /></span>
            	</a>
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <button aria-label="{@sitemap:title}" aria-expanded="false" class="open-submenu-sr">
                        <i class="fas fa-angle-right" aria-hidden="true"></i>
                    </button>
                </xsl:if>
            </div>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul class="level list-lvl-two">
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-2"/>
                </ul>
            </xsl:if>
    	</li>
    </xsl:template>
    
    <xsl:template match="page" mode="level-2">
        <li>
			<xsl:attribute name="class"><xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-submenu</xsl:if><xsl:if test="@sitemap:current or @sitemap:in-path='true'"> active</xsl:if></xsl:attribute>
            <div class="link">
        		<a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:in-path='true'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                    <xsl:choose>
                        <xsl:when test="@sitemap:current">
                            <xsl:attribute name="aria-current">page</xsl:attribute>
                        </xsl:when>
                        <xsl:when test="@sitemap:in-path='true'">
                            <xsl:attribute name="aria-current">true</xsl:attribute>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="className">external<xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                	<span><xsl:value-of select="@sitemap:title" /></span>
            	</a>
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <button aria-label="{@sitemap:title}" aria-expanded="false" class="open-submenu-sr">
                        <i class="fas fa-angle-right" aria-hidden="true"></i>
                    </button>
                </xsl:if>
            </div>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul class="level list-lvl-three">
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-3"/>
                </ul>
            </xsl:if>
    	</li>
    </xsl:template>
    
    <xsl:template match="page" mode="level-3">
        <li>
            <xsl:if test="@sitemap:current or @sitemap:in-path='true'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:in-path='true'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                <xsl:choose>
                    <xsl:when test="@sitemap:current">
                        <xsl:attribute name="aria-current">page</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="@sitemap:in-path='true'">
                        <xsl:attribute name="aria-current">true</xsl:attribute>
                    </xsl:when>
                </xsl:choose>
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="className">external<xsl:if test="@sitemap:in-path='true'"> active</xsl:if></xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            	<span><xsl:value-of select="@sitemap:title" /></span>
        	</a>
    	</li>
    </xsl:template>
    
    <xsl:template name="main-menu-mobile">
        <nav role="navigation" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label">
            <ul class="links mobile">
                <!-- For each page with SECTION tag : page[@PLUGIN_TAGS_SECTION] -->
                <xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                    <li>
                        <xsl:attribute name="class">
                            <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">has-submenu </xsl:if>
                        </xsl:attribute>
                        <a href="{resolver:resolve('page', @sitemap:id)}">
                            <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                                <xsl:call-template name="external-link-attributes"/>
                            </xsl:if>
                            <xsl:value-of select="@sitemap:title" />
                        </a>
                        
                        <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                            <button aria-label="{@sitemap:title}" aria-expanded="false">
                                    <i class="fas fa-angle-right" aria-hidden="true"></i>
                            </button>
                        </xsl:if>
                        
                        <xsl:call-template name="submenu-mobile-levels"/>
                    </li>
                </xsl:for-each>
            </ul>
        </nav>
    </xsl:template>
    
    <xsl:template name="submenu-mobile-levels">
        <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
            
            <div class="submenu">
                 <xsl:call-template name="menu-mobile-back"/>
                 
                 <ul>
                    <li class="title">
                        <a href="{resolver:resolve('page', @sitemap:id)}">
                            <xsl:value-of select="@sitemap:title" />
                        </a>
                    </li>
                    
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-mobile"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="level-mobile">
        <li>
            <xsl:attribute name="class"><xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-submenu</xsl:if></xsl:attribute>
            
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
                <span><xsl:value-of select="@sitemap:title" /></span>
            </a>
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <button aria-label="{@sitemap:title}" aria-expanded="false" class="open-submenu-sr">
                    <i class="fas fa-angle-right" aria-hidden="true"></i>
                </button>
            </xsl:if>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <div class="submenu">
                    <xsl:call-template name="menu-mobile-back"/>
                 
                    <ul>
                        <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="level-mobile"/>
                    </ul>
                </div>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template name="menu-mobile">
        <div class="menu-mobile" role="dialog" aria-modal="true" aria-label="skin.{$skin}:SKIN_NAV_MAIN_MENU" i18n:attr="aria-label">
            <xsl:call-template name="menu-mobile-close"/>
            <xsl:call-template name="menu-mobile-logo"/>
            <xsl:call-template name="main-menu-mobile"/>
            <div class="access-mobile"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="menu-mobile-close">
        <button 
            aria-label="skin.{$skin}:SKIN_NAV_MENU_MOBILE_CLOSE"
            i18n:attr="aria-label"
            class="close" 
            onclick="closeMenuMobile()">
            <i class="fas fa-times" aria-hidden="true"></i>
        </button>
    </xsl:template>
    
    <xsl:template name="menu-mobile-back">
        <button 
            aria-label="skin.{$skin}:SKIN_NAV_MENU_MOBILE_BACK"
            i18n:attr="aria-label"
            class="return" 
            onclick="closeLevel(this)">
            <i class="fas fa-arrow-left" aria-hidden="true"></i>
        </button>
    </xsl:template>
    
    <xsl:template name="menu-mobile-logo">
        <a href="{$site-uri-prefix}/{$lang}/index.html" class="logo-link">
             <img class="logo" src="{ametys:skinURL('templates/common/img/logo-white.png')}" alt="skin.{$skin}:SKIN_LOGO_ALT" i18n:attr="alt" />
        </a>
    </xsl:template>
    
    <xsl:template name="right-menu">
    	<div class="nav-perso">
            
            <xsl:call-template name="right-menu-additional-buttons"/>
            
    		<button class="close" onclick="closeNavPerso()" title="skin.{$skin}:SKIN_NAV_PERSO_CLOSE" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
    		<xsl:call-template name="user-right-menu"/>
    		
            <xsl:call-template name="right-menu-custom-top"/>
            
    		<xsl:call-template name="favoris">
    		    <xsl:with-param name="inputDataId" select="'applications'"/>
                <xsl:with-param name="userThemeId" select="'MES_APPLICATIONS'"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_MENU_APPLICATIONS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="extraLinksTitle"><i18n:text i18n:key="SKIN_MENU_APPLICATIONS_EXTRA_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="addUserLinkTitle"><i18n:text i18n:key="SKIN_MENU_APPLICATIONS_ADD_USER_LINK_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="class">favourites</xsl:with-param>
    		</xsl:call-template>
            
            <xsl:call-template name="right-menu-custom-middle"/>
    		
    		<xsl:call-template name="favoris">
                <xsl:with-param name="inputDataId" select="'favoris'"/>
                <xsl:with-param name="userThemeId" select="'MES_FAVORIS'"/>
                <xsl:with-param name="title"><i18n:text i18n:key="SKIN_MENU_FAVORIS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="extraLinksTitle"><i18n:text i18n:key="SKIN_MENU_FAVORIS_EXTRA_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="addUserLinkTitle"><i18n:text i18n:key="SKIN_MENU_FAVORIS_ADD_USER_LINK_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                <xsl:with-param name="class">favourites-inline</xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="right-menu-custom-bottom"/>
            
            <script>
               var openedMenu = 0;
               
                function openNavPerso() {
                    $j('.nav-perso').addClass('open');
                    $j('.espace-perso-btn-in-menu').addClass('open');
                    $j('.espace-perso-btn-in-menu').attr("aria-expanded", "true");
                    $j('.espace-perso-btn').addClass('open');
                    $j('.espace-perso-btn').attr("aria-expanded", "true");
                    $j('.overlayNav').addClass('active');
                 
                    if (openedMenu == 0) {
                        setTimeout(function () {
                            
                            <xsl:call-template name="favoris-open-menu-js">
                                <xsl:with-param name="inputDataId" select="'applications'"/>
                            </xsl:call-template>
                            
                            <xsl:call-template name="favoris-open-menu-js">
                                <xsl:with-param name="inputDataId" select="'favoris'"/>
                            </xsl:call-template>
                            
                        }, 200);
                    }
                    
                    setTimeout(function () {
                        $j('.nav-perso > .close').focus();
                    }, 100);
                    
                    openedMenu++;
                }
                
                function closeNavPerso() {
                    $j('.espace-perso-btn-in-menu').removeClass('open');
                    $j('.espace-perso-btn-in-menu').attr("aria-expanded", "false");
                    $j('.espace-perso-btn').removeClass('open');
                    $j('.espace-perso-btn').attr("aria-expanded", "false");
                    $j('.nav-perso').removeClass('open');
                    $j('.overlayNav').removeClass('active');
                    setTimeout(function () {
                        $j('.espace-perso-btn').focus();
                    }, 100);
                }
             </script>
             
             <xsl:call-template name="right-menu-additional-script"/>
    		
            <xsl:call-template name="right-menu-zone"/>
    	</div>
    </xsl:template>
    
    <xsl:template name="right-menu-additional-script"/>
    
    <xsl:template name="right-menu-zone">
        <div class="zone-right">
            <zone name="right"/>
        </div>
    </xsl:template>
    
    <xsl:template name="right-menu-additional-buttons"/>
    <xsl:template name="right-menu-custom-top"/>
    <xsl:template name="right-menu-custom-middle"/>
    <xsl:template name="right-menu-custom-bottom"/>
    
    <xsl:template name="favoris-open-menu-js">
        <xsl:param name="inputDataId"/>
        
        var $tool = $j('#tool-ametys_<xsl:value-of select="$inputDataId"/>');
	        $tool.HSAmetysTools($j('#tool-ametys_<xsl:value-of select="$inputDataId"/>').data('settings'));
	
	        $tool.on('elementDeactivated', deactivateLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementActivated', activateLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementMoved', moveLink_ametys_<xsl:value-of select="$inputDataId"/>);
	        $tool.on('elementDeleted', deleteLink_ametys_<xsl:value-of select="$inputDataId"/>);
            
            $tool.on('elementActivated', function(e, removeEl, addedEl) {
                $j(addedEl).find('.ametys-tools-list__action').focus();
            });
            $tool.on('elementDeactivated', function(e, removeEl, addedEl) {
                $j(addedEl).find('.ametys-tools-list__action').focus();
            });
            
            
    </xsl:template>
    
    <xsl:template name="favoris">
        <xsl:param name="userThemeId"/>
        <xsl:param name="inputDataId"/>
        <xsl:param name="title"/>
        <xsl:param name="extraLinksTitle"><i18n:text i18n:key="LINK_DIRECTORY_CONFIGURE_LINKS_ADD_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="addUserLinkTitle"><i18n:text i18n:key="LINK_DIRECTORY_ADD_USER_LINKS" i18n:catalogue="skin.{$skin}"/></xsl:param>
        
        <xsl:param name="class"/>
        
        <xsl:if test="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@userLink = 'false' or themes/theme/@id = $userThemeId]">
            <xsl:call-template name="configure-links-internal">
                <xsl:with-param name="links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/links/link[@userLink = 'false' or themes/theme/@id = $userThemeId]"/>
                <xsl:with-param name="configurable" select="/cms/inputData/linkDirectory[@id=$inputDataId]/@configurable"/>
                <xsl:with-param name="display-user-links" select="/cms/inputData/linkDirectory[@id=$inputDataId]/@displayUserLinks"/>
                <xsl:with-param name="savingId" select="$inputDataId"/>
                <xsl:with-param name="uniqueId" select="$inputDataId"/>
                <xsl:with-param name="title" select="$title"/>
                <xsl:with-param name="extraLinksTitle" select="$extraLinksTitle"/>
                <xsl:with-param name="addUserLinkTitle" select="$addUserLinkTitle"/>
                <xsl:with-param name="class" select="$class"/>
                <xsl:with-param name="userLinksThemeId" select="$userThemeId"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-right-menu">
    	<div class="profil">
            <div class="picture">
            	<xsl:call-template name="profil-img"/>
            </div>
            <div class="info">
                <span class="name"><xsl:value-of select="$currentUser/user/firstname"/></span>
                
                <xsl:call-template name="user-right-menu-links"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="user-right-menu-links">
        <xsl:if test="/cms/inputData/linkDirectory[@id='topMenu']/links/link">
            <ul>
                <xsl:apply-templates select="/cms/inputData/linkDirectory[@id='topMenu']/links/link[not(@disabled)]" mode="top-links">
                     <xsl:with-param name="showThemes">false</xsl:with-param>
                     <xsl:with-param name="showUrl">false</xsl:with-param>
                     <xsl:with-param name="showTitle">false</xsl:with-param>
                     <xsl:with-param name="width">22</xsl:with-param>
                     <xsl:with-param name="height">22</xsl:with-param>
                     <xsl:with-param name="uniqueId" select="concat('profile_link_', $uniqueId)"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="profil-img">
        <xsl:choose>
            <xsl:when test="$currentUser/user/imgUrl">
                <img src="{$currentUser/user/imgUrl}" alt=""/>
            </xsl:when>
            <xsl:otherwise>
                <img src="{ametys:skinURL('templates/common/img/avatar.png')}" alt=""/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="navinterieur">
        <xsl:if test="$sectionInPath">
            <div class="ametys-cms-service ametys-secondary-menu" data-content="">
            
                <nav role="navigation" aria-labelledby="secondarymenulabel">
                    <!-- Section title -->
                    <xsl:call-template name="navinterieur-title"/>
                    
                    <ul class="first">
                        <xsl:apply-templates select="$sectionInPath/page" mode="navinterieur"/>
                    </ul>
                </nav>
                
            </div>
            
            <xsl:call-template name="navinterieur-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="navinterieur-title">
        <h2 class="service-title open" id="secondarymenulabel">
            <xsl:value-of select="$sectionInPath/@sitemap:title" />
        </h2>
    </xsl:template>
    
    <!-- Menu nav intérieur -->
    <xsl:template match="page" mode="navinterieur">
        <xsl:param name="level">2</xsl:param>
        
        <xsl:variable name="hasChildren" select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']"/>        
        <li>
            <xsl:attribute name="class">
                <xsl:if test="$hasChildren">has-submenu</xsl:if>
                <xsl:if test="@sitemap:in-path='true' and not(@sitemap:current)"> open</xsl:if>
                <xsl:if test="@sitemap:in-path='true' and not($hasChildren)"> current-section</xsl:if>
            </xsl:attribute>
            
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:choose>
                    <xsl:when test="@sitemap:current='true'">
                        <xsl:attribute name="class">current</xsl:attribute>
                        <xsl:attribute name="aria-current">page</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="@sitemap:in-path='true'">
                        <xsl:attribute name="aria-current">true</xsl:attribute>
                    </xsl:when>
                </xsl:choose>
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes"/>
                </xsl:if>
                <xsl:value-of select="@sitemap:title" />
            </a>
            <xsl:if test="$hasChildren">
                <xsl:call-template name="nav-interieur-icon"/>
            </xsl:if>
            <xsl:if test="$hasChildren">
                <ul id="toggleNav-{generate-id()}">
                    <xsl:attribute name="class">
                        <xsl:text>level-</xsl:text><xsl:value-of select="$level"/>
                        <xsl:if test="@sitemap:in-path='true' and not(page)"> current-section</xsl:if>
                    </xsl:attribute>
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="navinterieur">
                        <xsl:with-param name="level" select="$level+1"/>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template name="nav-interieur-icon">
       <button class="chevron" type="button" aria-controls="toggleNav-{generate-id()}" aria-expanded="{@sitemap:in-path='true'}" aria-label="{@sitemap:title}">
         <svg aria-hidden="true" width="11.2535094px" height="7.26635041px" viewBox="0 0 11.2535094 7.26635041" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g stroke="none" stroke-width="1" fill="none"
                fill-rule="evenodd">
                <g id="Produit-interieur-colonne-droite"
                    transform="translate(-1468.748232, -594.617059)" fill="#1ABC9C"
                    fill-rule="nonzero">
                    <g id="menu-secondaire"
                        transform="translate(1011.000000, 306.000000)">
                        <g id="chevron" transform="translate(457.748232, 288.617059)">
                            <path d="M6.22440952,0.247425266 C5.89392783,-0.083056429 5.35958157,-0.083056429 5.02909987,0.25092715 L0.247861271,5.03216575 C-0.0826204237,5.35911123 -0.0826204237,5.89349182 0.247861271,6.22397352 L1.04591311,7.01848914 C1.37285859,7.34897083 1.90723918,7.34897083 2.23768654,7.01848914 L5.6267547,3.62945532 L9.01932473,7.01498726 C9.34627021,7.34543462 9.8806508,7.34543462 10.2111325,7.01498726 L11.0056481,6.2204373 C11.3361298,5.89349182 11.3361298,5.35911123 11.0056481,5.02866387 L6.22440952,0.247425266 Z"></path>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
       </button>
    </xsl:template>
    
    <xsl:template name="navinterieur-js">
        <script>
            
            $j(".ametys-secondary-menu .has-submenu .chevron").click(function (e) {
                e.preventDefault();
                var $parent = $j(this).closest(".has-submenu");
                if ($parent.hasClass("open")) {
                    // close
                    $parent.removeClass("open");
                    $parent.find(">ul").hide();
                    $j(this).attr("aria-expanded", false);
                } else {
                    // Open
                    $parent.addClass("open");
                    $parent.find(">ul").show();
                    $j(this).attr("aria-expanded", true);
                }
                 
                
                // scroll to the click
                $j("html, body").animate(
                   {
                      scrollTop: $j(this).offset().top - 200,
                    },
                   500
                );
            });
            
            $j(function () {
              $j(".ametys-secondary-menu li.open > ul").show();
            });

          </script>
    </xsl:template>
    
</xsl:stylesheet>