<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:link="org.ametys.plugins.linkdirectory.LinkDirectoryXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        extension-element-prefixes="ametys resolver link">

	<xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
	
	<xsl:param name="contextPath"/>
	<xsl:param name="skin"/>
	<xsl:param name="siteName"/>
	<xsl:param name="lang"/>
	<xsl:param name="mail"/>
    <xsl:param name="title"/>
    <xsl:param name="categoryTitle"/>
    <xsl:param name="number"/>
    <xsl:param name="date"/>
    
    <xsl:variable name="site" select="ametys:site()"/>
	<xsl:variable name="skincontext" select="concat($contextPath, '/skins/', $skin, '/resources')"/>
    <xsl:variable name="includeImages" select="ametys:siteParameter('newsletter-mail-include-images')"/>
    
    <!-- BEGIN CSS styles -->
    <xsl:variable name="fontFamily">"Montserrat", Arial, Helvetica, sans-serif</xsl:variable>
    <xsl:variable name="primary">#795198</xsl:variable>
    <xsl:variable name="secondary">#1ABC9C</xsl:variable>
    <xsl:variable name="h1Color"><xsl:value-of select="$primary"/></xsl:variable>
    <xsl:variable name="h2Color">#505767</xsl:variable>
    <xsl:variable name="h3Color">#505767</xsl:variable>
    <xsl:variable name="textColor">#353535</xsl:variable>
    <xsl:variable name="linkColor"><xsl:value-of select="$secondary"/></xsl:variable>
    <xsl:variable name="linkColorHover">#12997e</xsl:variable>
    
    <xsl:variable name="topBottomTextColor">#505154</xsl:variable><!-- couleur du texte en dehors du contenu de la newsletter (lien de redirection, désabonnement, mentions, ...) -->
    
    <xsl:variable name="actuBgColor">#F8F6FA</xsl:variable><!-- couleur de fond du block A la Une -->
    <xsl:variable name="actuItemBgColor">#FFFFFF</xsl:variable><!-- couleur de fond des éléments du bloc A la Une -->
    
    <xsl:variable name="agendaBgColor">#FFFFFF</xsl:variable><!-- couleur de fond du block Agenda -->
    <xsl:variable name="agendaItemBgColor">#F8F7FA</xsl:variable><!-- couleur de fond des éléments du bloc Agenda -->
    
    <xsl:variable name="actuTextColor"><xsl:value-of select="$textColor"/></xsl:variable>
    <xsl:variable name="actuDateColor">#6E7583</xsl:variable>
    
    <xsl:variable name="footerLeftBgColor"><xsl:value-of select="$primary"/></xsl:variable><!-- couleur de fond de la colonne gauche du pied de page -->
	<xsl:variable name="footerRightBgColor">#505767</xsl:variable><!-- couleur de fond de la colonne droite du pied de page -->
    <xsl:variable name="footerTextColor">#FFFFFF</xsl:variable><!-- couleur du texte du pied de page -->
    <!-- END CSS styles -->
    
	<xsl:template match="/">
		<html>
			<head>
				<xsl:copy-of select="/html/head/node()"/>
				
                <xsl:call-template name="head-css"/>
                <xsl:call-template name="custom-head-css"/>
			</head>
			
			<body>
				<xsl:call-template name="newsletter-body"/>
			</body>
		</html>
	</xsl:template>
    
    <xsl:template name="head-css">
        <style type="text/css">
            body,
            #bodyTable,
            #bodyCell,
            #bodyCell {
                height: 100% !important;
                margin: 0;
                padding: 0;
                width: 100% !important;
                font-family: <xsl:value-of select="$fontFamily"/>;
            }
    
            table {
                border-collapse: collapse;
            }
    
            table[id=bodyTable] {
                width: 100% !important;
                margin: auto;
                max-width: 750px !important;
                color: #4A5056;
                font-weight: normal;
            }
    
            table,
            td {
                mso-table-lspace: 0pt;
                mso-table-rspace: 0pt;
            }
    
            img {
                -ms-interpolation-mode: bicubic;
                outline: none;
                text-decoration: none;
            }
    
            body, table, td, p, a, li, blockquote {
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
                font-weight: normal !important;
            }

            body,
            #bodyTable {
                background-color: #FFFFFF;
            }
    
            #emailHeader,
            #emailSubFooter {
                background-color: #FFFFFF;
            }
            #emailHeader p,
            #emailSubFooter p {
            font-size: 12px;
                color: <xsl:value-of select="$topBottomTextColor"/>;
            }
    
            .emailHeaderFooterPadding {
                padding-top: 24px;
            }
    
            #emailHeader a,
            #emailSubFooter a {
                color: <xsl:value-of select="$topBottomTextColor"/> !important;
                text-decoration: underline !important;
                font-size: 12px !important;
            }
            
            <xsl:if test="$mail != 'true'">
            #emailHeader a:hover,
            #emailSubFooter a:hover {
                color: <xsl:value-of select="$primary"/> !important;
            }
            </xsl:if>
    
            #emailImage {
                background-color: #FFFFFF;
            }
    
            .padding-b-12 {
                padding-bottom: 12px;
            }
    
            .padding-t-30 {
                padding-top: 24px;
            }
    
            .padding-b-40 {
                padding-bottom: 40px;
            }
    
            .padding-t-10 {
                padding-top: 10px;
            }
    
            .padding-t-16 {
                padding-top: 16px;
            }
    
            .padding-b-16 {
                padding-bottom: 16px;
            }
    
            #emailImage img {
                display: block;
                margin: auto;
                max-width: 100%;
            }
    
            #emailTitle {
                background: #FFFFFF;
            }
    
            #emailHero {
                background-color: transparent;
                position: relative;
                z-index: 1;
            }
    
            #emailHeroInternal {
                background-color: #FFFFFF;
            }
    
            .email-top-text {
                color: <xsl:value-of select="$topBottomTextColor"/>;
                font-size: 12px;
                font-weight: 400;
            }
    
            .emailBody {
                background-color: <xsl:value-of select="$actuBgColor"/>;
            }
    
            .emailBody.removeMarginTop {
                margin-top: -70px;
            }
    
            .emailBodyTitle h2 {
                color: <xsl:value-of select="$primary"/>;
                font-size: 27px;
                font-weight: bold !important;
                letter-spacing: 0;
                margin: 0px;
                line-height: 36px;
                text-align: left;
            }
    
            .emailBlockActu {
                background-color: <xsl:value-of select="$actuItemBgColor"/>;
            }
            
            .emailBlockActu h3 {
                margin: 8px 0px !important;
                font-weight: 600;
                letter-spacing: 0;
                line-height: 26px;
            }
    
            .emailBlockActu p {
                margin: 0px !important;
                color: <xsl:value-of select="$actuTextColor"/>
            }
    
            .emailBlockActu img {
                width: 200px;
                height: 121px;
                object-fit: cover;
            }
    
            .emailBlockActuDate {
                color: <xsl:value-of select="$actuDateColor"/>;
                font-size: 14px;
                font-weight: 600;
                display: block;
                margin-top: 5px;
            }
    
            .emailBlockActu .chevron {
                color: <xsl:value-of select="$actuDateColor"/>;
                font-size: 12px;
                font-weight: 700;
                display: inline-block;
                margin: 0px 10px;
            }
    
            /* EMAIL BODY 1 END */
    
    
            .email-title-text {
                color: <xsl:value-of select="$textColor"/>;
                font-size: 18px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 22px;
            }
    
            .email-title-text span {
                font-size: 14px;
            }
    
            .email-subtitle-text {
                color: <xsl:value-of select="$textColor"/>;
                font-size: 12px;
                font-weight: 400;
                letter-spacing: 0;
                line-height: 18px;
                padding-top: 8px;
            }
             
             
            #emailHeroInternal h1 {
                color: <xsl:value-of select="$primary"/>;
                font-size: 24px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
            
            <xsl:if test="$mail != 'true'">
            #emailHeroInternal h1:before {
                display: none;
            } 
            </xsl:if>
    
            #emailHeroInternal h2 {
                color: <xsl:value-of select="$h2Color"/>;
                font-size: 20px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
    
            #emailHeroInternal h3 {
                color: <xsl:value-of select="$h3Color"/>;
                font-size: 16px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
             
            .emailBodyTitle .ametys-richtext-title-1 {
                color: <xsl:value-of select="$h1Color"/>;
                font-size: 24px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
    
            .emailBodyTitle .ametys-richtext-title-2 {
                color: <xsl:value-of select="$h2Color"/>;
                font-size: 20px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
    
            .emailBodyTitle .ametys-richtext-title-3 {
                color: <xsl:value-of select="$h3Color"/>;
                font-size: 16px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
            
            .ametys-richtext-title-1 {
                color: <xsl:value-of select="$h1Color"/>;
                font-size: 24px;
                font-weight: 750;
                text-align: center;
                letter-spacing: 0;
                line-height: 36px;
            }
    
            .ametys-richtext-title-2 {
                color: <xsl:value-of select="$h2Color"/>;
                font-size: 20px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
    
            .ametys-richtext-title-3 {
                color: <xsl:value-of select="$h3Color"/>;
                font-size: 16px;
                font-weight: 750;
                letter-spacing: 0;
                line-height: 36px;
            }
            
    
            p {
                color: <xsl:value-of select="$textColor"/>;
                font-size: 16px;
                font-weight: 300;
                letter-spacing: 0;
                line-height: 22px;
                margin-top: 16px;
            }
    
            .email-link {
                color: <xsl:value-of select="$linkColor"/>;
                font-size: 16px;
                font-weight: bold !important;
                letter-spacing: 0;
                text-decoration: underline !important;
                line-height: 22px;
            }
    
            <xsl:if test="$mail != 'true'">
            .email-link:hover {
                color: <xsl:value-of select="linkColorHover"/> !important;
            }
            </xsl:if>
    
            .emailBody3 {
                background-color: <xsl:value-of select="$agendaBgColor"/>;
            }
    
            .emailBody3 .emailBlockActu {
                background-color: <xsl:value-of select="$agendaItemBgColor"/>
            }
            
            #emailFooterRestezConnectes {
                background-color: <xsl:value-of select="$footerRightBgColor"/>;
                padding: 50px;
            }
    
            #emailFooter1Clic {
                background-color: <xsl:value-of select="$footerLeftBgColor"/>;
                padding: 50px;
            }
    
            #emailFooter h3 {
                color: #FFFFFF;
                font-size: 30px;
                margin: 0px;
                font-weight: 600;
                margin-bottom: 12px;
            }

            .emailFooter1ClicLi img {
                max-width: 14px;
                max-height: 14px;
                margin-top: 6px;
            }
    
            .emailFooter1ClicLi a {
                color: <xsl:value-of select="$footerTextColor"/>;
                font-size: 14px;
                font-weight: 600;
                letter-spacing: 0;
                line-height: 14px;
                text-decoration: none !important;
            }
    
            <xsl:if test="$mail != 'true'">
            .emailFooter1ClicLi a:hover {
                text-decoration: underline !important;
            }
            </xsl:if>
    
            .emailFooterRestezConnectesSocialLink img,
            .emailFooterRestezConnectesSocialLink svg{
                max-height: 24px;
            }
            
            <xsl:if test="$mail != 'true'">
            .emailFooterRestezConnectesSocialLink span:before {
                font-size: 24px;
                color: #FFFFFF;
            }   
            </xsl:if>       
    
            .emailFooterRestezConnectesSocialLink td {
                padding-right: 14px !important;
            }
    
            .paddingHero {
                padding: 36px !important;
            }
            
            #emailFooterRestezConnectes p {
                color: <xsl:value-of select="$footerTextColor"/>;
                font-size: 14px;
                font-weight: 600;
                letter-spacing: 0;
                line-height: 16px;
                text-decoration: none !important;
            }
            
            .mentions-newsletter p {
               letter-spacing: 0;
                line-height: 22px;
                margin-top: 16px;
                font-size: 12px;
                color: <xsl:value-of select="$topBottomTextColor"/>;
            }
    
            /* -------------------------------------
               MOBILE
               ------------------------------------- */
            <xsl:if test="$mail != 'true'">
            @media screen and (max-width: 750px) {
                body {
                    width: 100% !important;
                    min-width: 100% !important;
                }
    
                table {
                    width: 100% !important;
                }
    
                td {
                    max-width: 100% !important;
                }
    
                .responsivePadding {
                    padding: 0px 20px !important;
                    max-width: calc(100% - 80px);
                }
    
                .paddingHero {
                    padding: 20px !important;
                    max-width: calc(100% - 80px);
                }
    
                .paddingHero2 {
                    padding: 0px 20px !important;
                }
    
            
                #emailFooter1Clic,
                #emailFooterRestezConnectes {
                    display: block;
                    width: calc(100% - 80px);
                }
    
    
                .emailBlockActu td {
                    display: block;
                    width: auto;
                }
    
                #emailFooter1Clic,
                #emailFooterRestezConnectes {
                    padding: 40px !important;
                }
    
                .emailBlockActu td img  {
                    width: 100%;
                    height: 200px;
                    margin-bottom: -30px;
                }
    
                .emailFooterRestezConnectesSocialLink {
                    width: auto !important;
                }
            }
            </xsl:if>
        </style>
    </xsl:template>
    
    <xsl:template name="custom-head-css">
    	<!-- Insert your custom css here -->
    </xsl:template>
	
	<xsl:template name="unsubscribe">
        <tr>
            <td id="footer" align="center" valign="middle">             
                <xsl:if test="$mail = 'true'">
                    <tr>
                        <td class="mentions">
                            <br/>
                            <p><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_MENTIONS_1" i18n:catalogue="skin.{$skin}"/></p>
                            <p>
                                <i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_MENTIONS_3" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text>
                                <a href="{$contextPath}/{$lang}/_plugins/newsletter/page/unsubscribe?token=#token#"><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_MENTIONS_4" i18n:catalogue="skin.{$skin}"/></a><br/>
                                <i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_MENTIONS_5" i18n:catalogue="skin.{$skin}"/>
                            </p>
                            
                            <p class="copy"><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_COPYRIGHT" i18n:catalogue="skin.{$skin}"/></p>
                        </td>
                    </tr>
                </xsl:if>               
            </td>
        </tr>
    </xsl:template>

	<xsl:template name="newsletter-body">
        <center style="background-color: #fff;" >
    		<div>
                <table cellspacing="0" cellpadding="0">
                    <xsl:if test="$mail = 'true'">
                        <xsl:call-template name="redirect" />
                    </xsl:if>
    
                    <xsl:call-template name="header" />
    
                    <xsl:call-template name="content" />
                    
                    <xsl:call-template name="footer" />
                    
                    <div class="mentions-newsletter" >
                        <xsl:call-template name="unsubscribe" />
                    </div>
                </table>
    		</div>
        </center>
        <xsl:call-template name="newsletter-track-events"/>
	</xsl:template>
    
    
    <xsl:template name="newsletter-track-events">
        <!-- Insert here the code to track events for matomo or google-analytics -->
    </xsl:template>
    
	<!-- *************************** BEGIN redirect link *************************** -->
	<xsl:template name="redirect">
	    <table bgcolor="#fff" border="0" cellpadding="0" cellspacing="0" width="750" id="emailHeader">
	        <tr>
	            <td align="center" valign="top">
	                <table border="0" cellpadding="0" cellspacing="0" width="100%">
	                    <tr>
	                        <td align="center" valign="top">
	                            <table border="0" cellpadding="10" cellspacing="0" width="750"
	                                class="flexibleContainer">
	                                <tr>
	                                    <td valign="top" width="750">
	                                        <table align="left" border="0" cellpadding="0" cellspacing="0"
	                                            width="100%">
	                                            <tr>
	                                                <td valign="middle" class="flexibleContainerBox">
	                                                    <table border="0" cellpadding="0" cellspacing="0"
	                                                        width="100%" style="max-width:100%;">
	                                                        <tr>
	                                                            <td align="center" style="width: 100% !important;" class="emailHeaderFooterPadding">
	                                                                <p style="text-align: center; width: 100%;">
	                                                                 <i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_REDIRECT_1" i18n:catalogue="skin.{$skin}"/>
	                                                                 <a href="{$contextPath}/_wrapped-content/{/html/head/meta[@name = 'contentName']/@content}.html"><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_REDIRECT_2" i18n:catalogue="skin.{$skin}"/></a>
	                                                                </p>
	                                                            </td>
	                                                        </tr>
	                                                    </table>
	                                                </td>
	                                            </tr>
	                                        </table>
	                                    </td>
	                                </tr>
	                            </table>
	                        </td>
	                    </tr>
	                </table>
	            </td>
	        </tr>
	    </table>
	</xsl:template>
    <!-- *************************** END redirect link *************************** -->

	<!-- *************************** BEGIN email header *************************** -->
	<xsl:template name="header">
        <xsl:call-template name="header-image"/>
        <xsl:call-template name="header-title"/>
	</xsl:template>
    
    <xsl:template name="header-image">
        <table bgcolor="#fff" border="0" cellpadding="0" cellspacing="0" width="750" id="emailImage">
            <tr>
                <td align="center" valign="top">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td align="center" valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="750"
                                    class="flexibleContainer">
                                    <tr>
                                        <td valign="top" width="750">
                                            <table align="left" border="0" cellpadding="0" cellspacing="0"
                                                width="100%">
                                                <tr>
                                                    <td valign="middle" class="flexibleContainerBox">
                                                        <table border="0" cellpadding="0" cellspacing="0"
                                                            width="100%" style="max-width:100%;">
                                                            <tr>
                                                                <td align="center" class="padding-b-12">
                                                                     <xsl:call-template name="header-image-img"/>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template name="header-image-img">
    	<xsl:choose>
            <xsl:when test="$mail = 'true'">
                <img src="{ametys:skinImageBase64('templates/common/img/newsletter/header.png')}" alt="skin.{$skin}:SKIN_CONTENT_NEWSLETTER_TEXT_IMG_HEADER" i18n:attr="alt"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="{ametys:skinURL('templates/common/img/newsletter/header.png')}" alt="skin.{$skin}:SKIN_CONTENT_NEWSLETTER_TEXT_IMG_HEADER" i18n:attr="alt"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="header-title">
        <table bgcolor="#fff" border="0" cellpadding="0" cellspacing="0" width="750" id="emailTitle">
            <tr>
                <td align="center" valign="top">            
                    <table border="0" cellpadding="0" cellspacing="0" width="750" class="flexibleContainer">
                        <tr>
                            <td valign="top" width="750">
                                <table align="left" border="0" cellpadding="0" cellspacing="0"
                                    width="100%">
                                    <tr>
                                        <td valign="middle" class="flexibleContainerBox">
                                            <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width:100%;">
                                                <tr>
                                                    <td align="left" style="padding-left: 50px" class="responsivePadding">
                                                        <div class="email-title-text">
                                                            <xsl:if test="/html/head/meta[@name = 'number']/@content != '' and /html/head/meta[@name = 'number']/@content != '0'">
                                                                <i18n:text i18n:key="SKIN_CONTENT_NEWSLETTER_NUMBER" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text><xsl:value-of select="/html/head/meta[@name = 'number']/@content"/>
                                                            </xsl:if>
                                                             
                                                            <span>
                                                               <xsl:if test="(/html/head/meta[@name = 'number']/@content != '' and /html/head/meta[@name = 'number']/@content != '0') and /html/head/meta[@name = 'date']/@content != ''">
                                                                   <xsl:text> - </xsl:text>
                                                                </xsl:if>   
                                                                
                                                               <xsl:if test="/html/head/meta[@name = 'date']/@content != ''">
                                                                   <i18n:date src-pattern="yyyy-MM-dd'T'hh:mm:ss" pattern="MMMM yyyy"><xsl:value-of select="/html/head/meta[@name = 'date']/@content"/></i18n:date>
                                                               </xsl:if>
                                                            </span>
                                                        </div>
                                                        
                                                        <xsl:call-template name="header-subtitle"/>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template name="header-subtitle">
        <div class="email-subtitle-text">
            <span><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_SUBTITLE" i18n:catalogue="skin.{$skin}"/></span>
        </div>
    </xsl:template>
    <!-- ***************************  END email header *************************** -->
	
    <!-- *************************** BEGIN email content *************************** -->
	<xsl:template name="content">
		<tr>
			<td>
                <xsl:apply-templates select="/html/body/node()"/>
			</td>
		</tr>
	</xsl:template>
    <!-- *************************** END email content *************************** -->
	
	<!-- *************************** BEGIN email footer *************************** -->
	<xsl:template name="footer">
	    <table bgcolor="#fff" border="0" cellpadding="0" cellspacing="0" width="750" id="emailFooter">
	        <tr>
                <td align="center" valign="top">
	                <table border="0" cellpadding="0" cellspacing="0" width="750" class="flexibleContainer">
	                    <tr>
	                        <td valign="top" width="750">
	                            <table align="center" border="0" cellpadding="0" cellspacing="0" width="750px">
	                                <tr>
	                                    <td valign="top" class="flexibleContainerBox">
	                                        <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width:100%;">
	                                            <tr>
                                                    <td width="50%" valign="top" align="left" id="emailFooter1Clic">
	                                                    <xsl:call-template name="footer-left-content"/>
                                                    </td>
	
	                                                <td valign="top" width="50%" align="left" id="emailFooterRestezConnectes">
	                                                    <xsl:call-template name="footer-right-content"/>
	                                                </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
	    </table>
	</xsl:template>
    
    <xsl:template name="footer-left-content">
        <h3><i18n:text i18n:key="SKIN_NEWSLETTER_ONE_CLICK_ACCESS_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
    
        <xsl:call-template name="one-click-access"/>
    </xsl:template>
    
    <xsl:template name="footer-right-content">
        <h3><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
	                                                    
        <p><i18n:text i18n:key="SKIN_NEWSLETTER_TEMPLATE_FOOTER_SUBTITLE" i18n:catalogue="skin.{$skin}"/></p>

        <table class="emailFooterRestezConnectesSocialLink">
            <tr>
               <xsl:call-template name="social-networks" />
            </tr>
        </table>
    </xsl:template>
    <!-- ***************************  END email footer *************************** -->
	
	<!-- template use to display link(s) social networks-->
	<xsl:template name="social-networks">
	   <xsl:variable name="links" select="link:getLinks($site, $lang, 'SOCIAL_NETWORKS_NEWSLETTER')"/>
	   
	   <xsl:for-each select="($links/link)">
	      <td valign="middle">
	           <a href="{@url}">
	            <xsl:attribute name="href">
	                <xsl:choose>
	                  <xsl:when test="@urlType = 'PAGE'"><xsl:value-of select="resolver:resolve('page', @url)"/></xsl:when>
	                  <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
	                </xsl:choose>
	            </xsl:attribute>
	            
	            <xsl:choose>
		            <xsl:when test="@pictureType != ''">
						<xsl:choose>
                            <xsl:when test="@pictureType = 'glyph'">
						      <span class="picture link-glyph {@pictureGlyph}"></span>
							</xsl:when>
							
							<xsl:otherwise>
							    <xsl:variable name="id">
									<xsl:choose>
									    <xsl:when test="@pictureType = 'resource'">
							              <xsl:value-of select="@pictureId"/>
									    </xsl:when>
									    <xsl:when test="@pictureType = 'external'">
									        <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
									    </xsl:when>
									</xsl:choose>
								</xsl:variable>
						
                                <img src="{resolver:resolveBoundedImageAsBase64(@imageType, $id, 30, 30)}" alt="{@pictureAlternative}"/>
						           
						       </xsl:otherwise>
						   </xsl:choose>
						</xsl:when>
						<xsl:otherwise>
						    <xsl:value-of select="@title"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </td>
        </xsl:for-each>
	</xsl:template>
    
    <!-- Template use to display page(s) on one-click access -->
	<xsl:template name="one-click-access">
        <xsl:variable name="link-one-click-access" select="ametys:findPagesIdsByTag($siteName, $lang, 'NEWSLETTER_ONE_CLICK_ACCESS')"/>
	   
	    <xsl:for-each select="$link-one-click-access">
	       <table cellpadding="4" class="emailFooter1ClicLi">
                <tr>
                    <xsl:attribute name="class">
                      <xsl:if test="position() = 1"><xsl:text>first</xsl:text></xsl:if>
                      <xsl:if test="position() = last()"><xsl:text> last</xsl:text></xsl:if>
                    </xsl:attribute>
                    <td valign="middle" style="max-width: 16px !important; width: 16px !important;">
	                   <xsl:choose>
	                       <xsl:when test="$mail = 'true'">
	                           <img width="14px" height="14px" src="{ametys:skinImageBase64('templates/common/img/newsletter/arrow-white.png')}" alt="skin.{$skin}:SKIN_CONTENT_NEWSLETTER_ARROW_RIGHT" i18n:attr="alt"/>
	                       </xsl:when>
	                       <xsl:otherwise>
	                           <img width="14px" height="14px" src="{ametys:skinURL('templates/common/img/newsletter/arrow-white.png')}" alt="skin.{$skin}:SKIN_CONTENT_NEWSLETTER_ARROW_RIGHT" i18n:attr="alt"/>
	                       </xsl:otherwise>
	                   </xsl:choose>
                     </td>
                     <td valign="middle"><a href="{resolver:resolve('page', @id)}"><xsl:value-of select="ametys:pageTitle(@id)"/></a></td>
                </tr>
            </table>
	    </xsl:for-each>
    </xsl:template> 

	<xsl:template match="*">
    	<xsl:copy>
    		<xsl:copy-of select="@*"/>
    		<xsl:apply-templates/>
    	</xsl:copy>
    </xsl:template>
    
	<xsl:template match="processing-instruction()">
		<xsl:copy-of select="."/>
	</xsl:template>
    
</xsl:stylesheet>
