<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="plugin:forms://pages/services/display/display_1.0.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">forms signal close</xsl:variable>
    
    <xsl:variable name="hideSignalForm" select="ametys:templateParameter('hideSignalForm')"/>
    <xsl:variable name="is-empty" select="$hideSignalForm = 'true'"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/forms/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/form-signal/scss/main.css')}" />
    </xsl:template>
    
    <!-- No title -->
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <!-- Override to show/hide form with a button -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="btn-form-signal"/>
        
        <xsl:call-template name="view">
            <xsl:with-param name="level" select="'1'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="btn-form-signal">
        <a href="javascript:void(0)" onclick="openProblem(this)" class="btn btn-problem">
            <xsl:call-template name="btn-form-signal-title"/>
            <i class="fas fa-chevron-up"></i>
        </a>
        <xsl:call-template name="btn-form-signal-script"/>
    </xsl:template>
    
    <xsl:template name="btn-form-signal-title">
        <xsl:value-of select="form/title"/>       
    </xsl:template>
    
    <xsl:template name="btn-form-signal-script">
        <script>
            function openProblem(btn) {
                $j(btn).closest(".signal").toggleClass("close");
            }
        </script>
    </xsl:template>
    
    <!-- Override to change label of submit button -->
    <xsl:template name="submit-button-front">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
        
        <a class="btn submit" id="submit-{$pos}-{$uniqueId" href="javascript:void(0)" >
            <xsl:attribute name="onclick">try { AmetysFormsHelper.endForm('<xsl:value-of select="$uniqueId" />', <xsl:value-of select="$pos"/>); } catch(e) {} return false;</xsl:attribute>
            <span class="plus">+</span>
            <span><i18n:text i18n:key="SERVICE_FORMS_SIGNAL_SUBMIT_BTN" i18n:catalogue="skin.{$skin}"/></span>
        </a>
    </xsl:template>
    
</xsl:stylesheet>
