<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:linkDirectory="org.ametys.plugins.linkdirectory.LinkDirectoryXSLTHelper"
        exclude-result-prefixes="ametys math">

    <xsl:import href="plugin:link-directory://pages/services/directory/thumbnails_1.1.xsl"/> 
    
    <xsl:variable name="common-service-css-class-name"> ametys-home-tools </xsl:variable>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/home-tools-directory/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/ametys-tools.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
        
        <script type="text/javascript">
            $j().ready(function() {
                var $tool = $j('#tool-ametys_<xsl:value-of select="$uniqueId"/>');
    		    $tool.HSAmetysTools($j('#tool-ametys_<xsl:value-of select="$uniqueId"/>').data('settings'));
    		
                tippy('.ametys-home-tools .ametys-tools-list__item [data-tippy-content]', {});
            });
	   </script>
    </xsl:template>
    
    
    <!-- Override to by-pass test done in services/web/pages/services/common.xsl for title rendering -->
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
        
        <h1 class="service-title">
            <xsl:copy-of select="$title"/>
        </h1>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-tools" id="tool-ametys_{$uniqueId}" >
              <div class="">
	              <p data-no-items-text="" class="ametys-tools-no-items-text"><i18n:text i18n:key="LINK_DIRECTORY_NO_TOOLS" i18n:catalogue="skin.{$skin}"/></p>
	               
	              <!-- Selected links -->
	              <div id="selected-links-ametys_{$uniqueId}" data-list-wrap="" class="ametys-tools-list-wrap ametys-animated-heigth">
	                  <ul data-list="" class="ametys-tools-list ametys-tools-list_editable">
                           <!-- In this view a max of 10 items are supported -->
                           <xsl:apply-templates select="link[position() &lt;= 10]" mode="app"/>
	                  </ul>
	              </div>
	          </div>
        </div>
        
        <xsl:call-template name="link-bottom"/>
    </xsl:template>
    
    <xsl:template match="link" mode="app">
        <xsl:param name="uniqueId"/>
        
        <li data-list-item="" class="ametys-tools-list__item">
            <xsl:if test="@userLink = 'true'">
                <xsl:attribute name="data-app-type">custom</xsl:attribute>
            </xsl:if>
            <span class="material-icons ametys-tools-list__action">close</span>
            
            <a data-list-link="" target="_blank" class="ametys-tools-list__link" data-serverid="{@id}">
                <xsl:if test="normalize-space(@content) != ''">
                    <xsl:attribute name="data-tippy-content"><xsl:value-of select="@content"/></xsl:attribute>
                </xsl:if>
                <xsl:attribute name="href">
                    <xsl:choose>
                        <xsl:when test="@urlType = 'PAGE'">
                            <xsl:value-of select="resolver:resolve('page', @url)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="@url"/>
                        </xsl:otherwise>
                    </xsl:choose>
              </xsl:attribute>
              
              <xsl:apply-templates select="." mode="app-icon"/>
                                              
              <xsl:apply-templates select="." mode="app-title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="link" mode="app-title">
        <span class="ametys-tools-list__title">
            <xsl:value-of select="@title"/>
        </span>
    </xsl:template>
    
    <xsl:template match="link" mode="app-icon">
        <div class="icon">
	        <xsl:choose>
	            <xsl:when test="@pictureType = 'glyph'">
	                <i class="fas picture link-glyph {@pictureGlyph}"></i>
	            </xsl:when>
	            <xsl:when test="@pictureType != ''">
	                <xsl:variable name="id">
	                    <xsl:choose>
	                        <xsl:when test="@pictureType = 'resource'">
	                            <xsl:value-of select="@pictureId"/>
	                        </xsl:when>
	                        <xsl:when test="@pictureType = 'external'">
	                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
	                        </xsl:when>
	                    </xsl:choose>
	                </xsl:variable>
	        
	                <img class="svg" src="{resolver:resolveBoundedImage(@imageType, $id, 35, 35)}" alt="{@pictureAlternative}"/>
	            </xsl:when>
	            <xsl:otherwise>
	                <i>
                        <xsl:value-of select="substring(@title, 0, 3)"/>
                    </i>
	            </xsl:otherwise>
	        </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="link-bottom">
        <xsl:variable name="allTools" select="ametys:serviceViewParameter('link')"/>
        <xsl:if test="$allTools">
             <a href="{resolver:resolve('page', $allTools, false(), true())}" class="btn desktop">
                <span class="plus">+</span>
                <span>
                     <xsl:choose>
                        <xsl:when test="ametys:serviceViewParameter('linkTitle') != ''">
                            <xsl:value-of select="ametys:serviceViewParameter('linkTitle')"/>
                        </xsl:when>
                        <xsl:otherwise>
                             <i18n:text i18n:key="SKIN_LINK_DIRECTORY_ALL_TOOLS" i18n:catalogue="skin.{$skin}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                 </span>
             </a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>       
