<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="plugin:ugc://pages/services/ugc/form.xsl"/>	
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function() {
                var $input = $j('.ugc form .field input');
                $input.each(function() {
                    var $this = $j(this),
                        label = $this.closest('.field').find('.label label').text();
                        
                    $this.attr('placeholder', label);
                })
                
                var $textarea = $j('.ugc form .field textarea');
                $textarea.each(function() {
                    var $this = $j(this),
                        label = $this.closest('.field').find('.label label').text();
                        
                    $this.attr('placeholder', label);
                })
                
                var opt = $j("select[name='category'] option[value='']");
                opt.text("- <i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_CATEGORY" i18n:catalogue="plugin.classified-ads"/> -");
            });
        </script>
        
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/ugc/mixin/view|/ugc/content-type/view"/>
        </xsl:call-template>
        
    </xsl:template>
    
    <xsl:template match="metadata[@type='composite' and @name='illustrations']" mode="contenttype-form-field">
        <xsl:param name="fieldId" select="translate(@path, '/', '-')"/>
        <xsl:param name="fieldName" select="translate(@path, '/', '.')"/>
        <xsl:param name="values"/>
        <xsl:param name="contentValues"/>
        <xsl:param name="value" select="$values/*[local-name() = $fieldName]"/>
        <xsl:param name="errors" />
        <xsl:param name="uniqueId" />
        
        <div class="add-photos">
            <xsl:apply-templates select="metadata" mode="contenttype-form-field">
                <xsl:with-param name="values" select="$values" />
                <xsl:with-param name="contentValues" select="$contentValues" />
                <xsl:with-param name="errors" select="$errors" />
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
</xsl:stylesheet>		
