<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        		xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exslt="http://exslt.org/common" 
        		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        		exclude-result-prefixes="ametys resolver filenameutils exslt">
	
	<xsl:import href="plugin:web://pages/services/attach/attachments_small_3.3.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    	
    <xsl:variable name="common-service-css-class-name">last-documents</xsl:variable>	
    <xsl:variable name="maxSize">6</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
   
        <h2 class="service-title"><xsl:copy-of select="$title"/></h2>
   	</xsl:template>
    
    <xsl:template name="attachment-list">
        <xsl:if test="/Attachments//File">
            <div class="documents">
                <xsl:variable name="documents">
                    <xsl:for-each select="/Attachments//File">
                        <xsl:sort select="@lastModified" order="descending"/>
                        <xsl:copy-of select="."></xsl:copy-of>
                    </xsl:for-each>
                </xsl:variable>
                
                <xsl:apply-templates select="exslt:node-set($documents)/File[position() &lt;= $maxSize]"/>
            </div>
        </xsl:if>
    </xsl:template>    
    
    <xsl:template match="File">
        <div class="document">
            <a href="{resolver:resolve('attachment-page', @id, true())}" title="{@name} ({size})">
				<div class="left">
					<xsl:call-template name="file-icon">
                        <xsl:with-param name="filename" select="@name"/>
                    </xsl:call-template>
	                <span class="title"><xsl:value-of select="@name"/></span>
                </div>
            </a>
        </div>
    </xsl:template>
	
</xsl:stylesheet>		
