<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
    extension-element-prefixes="resolver filenameutils">
    
    <xsl:variable name="common-service-css-class-name">ametys-zone-ressources</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/attachments/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <ul id="{$id}" class="attachment-list">
            <xsl:call-template name="list-folders"/>
            
            <xsl:call-template name="list-files"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="list-folders"/>
    
    <xsl:template name="list-files"/>
    
    <xsl:template match="*" mode="folder">
        <li>
            <xsl:apply-templates select="." mode="folder-icon"/>
            <xsl:apply-templates select="." mode="folder-name"/>
            
            <xsl:apply-templates select="." mode="folder-children"/>
        </li>
    </xsl:template>
    
    <xsl:template match="*" mode="folder-icon">
        <i class="fas fa-folder"></i>
    </xsl:template>
    
    <xsl:template match="*" mode="folder-name">
        <span><xsl:value-of select="@name"/></span>
    </xsl:template>
    
    <xsl:template match="*" mode="folder-children">
        <xsl:if test="node()">
            <ul>
                <xsl:call-template name="list-folders"/>
                
                <xsl:call-template name="list-files"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="*" mode="file">
        
        <li>
            <a>
                <xsl:apply-templates select="." mode="file-href-attr"/>
                <xsl:apply-templates select="." mode="file-title-attr"/>
                <xsl:apply-templates select="." mode="file-icon"/>
                <xsl:apply-templates select="." mode="file-filename"/>
                <xsl:apply-templates select="." mode="file-extension"/>
                <xsl:apply-templates select="." mode="file-size"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="*" mode="file-href-attr"/>
    
    <xsl:template match="*" mode="file-title-attr">
        <xsl:variable name="i18nparams"><filename><xsl:value-of select="@name"/></filename></xsl:variable> 
        
        <xsl:attribute name="title">
            <xsl:value-of select="ametys:translate(concat('skin.', $skin, ':SERVICE_FILE_TOOLTIP'), $lang, $i18nparams)"/>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="*" mode="file-icon">
        <xsl:call-template name="file-icon"/>
    </xsl:template>
    
    <xsl:template match="*" mode="file-filename">
        <span><xsl:value-of select="@name"/></span>
    </xsl:template>
    
    <xsl:template match="*" mode="file-extension"/>
    
    <xsl:template match="*" mode="file-size">
        <span class="size">(<xsl:call-template name="format-size"><xsl:with-param name="size" select="@size"/></xsl:call-template>)</span>
    </xsl:template>
    
   <xsl:template name="file-icon">
    	<xsl:param name="name" select="filenameutils:getExtension(@name)"/>
    	<i>
    		<xsl:attribute name="class"><xsl:text>fas fa-</xsl:text>
    			<xsl:choose>
    				<xsl:when test="$name = 'doc' or $name = 'docx' or $name = 'dot'">file-word</xsl:when>
    				<xsl:when test="$name = 'avi' or $name = 'flv' or $name = 'mov' or $name = 'mpeg' or $name = 'mgp' or $name = 'swf' or $name = 'wmv'">file-video</xsl:when>
    				<xsl:when test="$name = 'bmp' or $name = 'gif' or $name = 'jpeg' or $name = 'jpg' or $name = 'png' or $name = 'psd' or $name = 'psp'">file-image</xsl:when>
    				<xsl:when test="$name = 'pdf'">file-pdf</xsl:when>
    				<xsl:when test="$name = 'pps' or $name = 'ppsx' or $name = 'ppt' or $name = 'pptx'">file-powerpoint</xsl:when>
    				<xsl:when test="$name = 'mid' or $name = 'mod' or $name = 'mp3'">file-audio</xsl:when>
    				<xsl:when test="$name = 'xls' or $name = 'xlsx'">file-excel</xsl:when>
    				<xsl:when test="$name = 'css' or $name = 'wml' or $name = 'xsl' or $name = 'htm' or $name = 'html' or $name = 'xhtml'">code</xsl:when>
    				<xsl:when test="$name = 'tar' or $name = 'rar' or $name = 'zip' or $name = 'tgz' or $name = 'jar'">archive</xsl:when>
    				<xsl:when test="$name = 'txt' or $name = 'odp' or $name = 'ods' or $name = 'odt' or $name = 'sxi' or $name = 'sxw'">file-alt</xsl:when>
					<xsl:when test="$name = 'cvs' or $name = 'sh' or $name = 'unkown' or $name = 'tgz' or $name = 'jar'">file</xsl:when>
    				<xsl:otherwise>file</xsl:otherwise>
    			</xsl:choose>
    		</xsl:attribute>
   		</i>
	</xsl:template>
   
</xsl:stylesheet>