<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
		exclude-result-prefixes="ametys">
	
	<xsl:import href="plugin:web://pages/services/explorer-folder/files-tree_3.3.xsl"/>
	<xsl:import href="skin://services/web/pages/services/common-files-tree.xsl"/>
	
    <xsl:template name="list-folders">
        <xsl:apply-templates select="Node[@type = 'collection']" mode="folder">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="list-files">
        <xsl:apply-templates select="Node[@type = 'resource']" mode="file">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'collection']" mode="folder-children">
        <xsl:if test="Node">
            <ul>
                <xsl:call-template name="list-folders"/>
                
                <xsl:call-template name="list-files"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']" mode="file-href-attr">
        <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('explorer', @id, true())"/></xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>		
