<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                xmlns:exslt="http://exslt.org/common" 
                extension-element-prefixes="resolver filenameutils exslt">
	
	<xsl:import href="service:web://pages/services/explorer-folder/files_small_3.3.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    
	<xsl:variable name="common-service-css-class-name">service-documents-page attachments explorer-folder small-icons</xsl:variable>
    
    <xsl:template name="attachment-list">
        <xsl:apply-templates select="Node[@type = 'collection']">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="Node[@type = 'resource']">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'collection' and parent::*]">
        <xsl:apply-templates select="Node[@type = 'resource']">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'resource']">
        <div class="document">
            <a href="{resolver:resolve('explorer', @id, true())}" title="{@name}">
                <div class="icon">
                    <xsl:call-template name="file-icon">
                        <xsl:with-param name="filename" select="@name"/>
                    </xsl:call-template>
                </div>
                <div class="text">
                    <xsl:value-of select="@name"/>
                    <span class="weight">
                        <xsl:text> (</xsl:text>
                        <xsl:call-template name="format-size">
                            <xsl:with-param name="size" select="@size"></xsl:with-param>
                        </xsl:call-template>
                        <xsl:text>)</xsl:text>
                    </span>
                </div>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>		
