<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math"
                xmlns:exslt="http://exslt.org/common" 
                extension-element-prefixes="resolver filenameutils exslt">
	
	<xsl:import href="service:web://pages/services/explorer-folder/files_small_3.3.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    
    <xsl:variable name="maxSize">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('maxSize') != '' and ametys:serviceViewParameter('maxSize') &gt; 0">
                <xsl:value-of select="ametys:serviceViewParameter('maxSize')"/>
            </xsl:when>
            <xsl:otherwise>6<!-- Default value --></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
	<xsl:variable name="common-service-css-class-name">attachments explorer-folder small-icons</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:param name="title"/>
        
        <xsl:if test="$title">
            <h1 class="service-title"><xsl:copy-of select="$title"/></h1>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <div class="flex">
                <xsl:call-template name="common-service-body-nonempty-content-title">
                    <xsl:with-param name="title" select="$header"/>
                </xsl:call-template>
                <xsl:call-template name="all-documents-link"/>
             </div>    
             
             <xsl:call-template name="common-service-body-nonempty-content-content"/>
             
             <xsl:call-template name="all-documents-link">
                <xsl:with-param name="mobile" select="true()"/>
             </xsl:call-template>
        </div>
    </xsl:template>
    
   <xsl:template name="attachment-list">
        <xsl:variable name="documents">
            <xsl:for-each select=".//Node[@type = 'resource']">
                <xsl:sort select="@lastModified" order="descending"/>
                <xsl:copy-of select="."></xsl:copy-of>
            </xsl:for-each>
        </xsl:variable>
        
        <div id="{$id}" class="documents">
            <xsl:apply-templates select="exslt:node-set($documents)/Node[@type = 'resource' and position() &lt;= $maxSize]"/>
        </div>
   </xsl:template>

    <xsl:template match="Node[@type = 'resource']">
        <div class="document">
            <a href="{resolver:resolve('explorer', @id, true())}" title="{@name}">
                <div class="left">
                    <xsl:call-template name="file-icon">
                        <xsl:with-param name="filename" select="@name"/>
                    </xsl:call-template>
                    <span class="title trunk1"><xsl:value-of select="@name"/></span>
                </div>
                <div class="date-container">
                    <xsl:call-template name="dates">
                        <xsl:with-param name="startDate" select="@lastModified"/>
                    </xsl:call-template>
                </div>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="all-documents-link">
        <xsl:param name="mobile" select="false()"/>
        
        <xsl:variable name="allDocsPage">
            <xsl:choose>
                <xsl:when test="ametys:serviceViewParameter('link') != ''">
                    <xsl:value-of select="ametys:serviceViewParameter('link')"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- For legacy pupose -->
                    <xsl:variable name="taggedPage" select="ametys:findPagesIdsByTag('ALL_DOCUMENTS')"/>
                    <xsl:if test="$taggedPage"><xsl:value-of select="$taggedPage/@id"/></xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:if test="$allDocsPage != ''">
            <a href="{resolver:resolve('page', $allDocsPage)}" class="btn desktop">  
                <xsl:if test="$mobile">
                    <xsl:attribute name="class">btn mobile white</xsl:attribute>
                </xsl:if>
                <span class="plus">+</span>
                <span>
                     <xsl:choose>
                        <xsl:when test="ametys:serviceViewParameter('linkTitle') != ''">
                            <xsl:value-of select="ametys:serviceViewParameter('linkTitle')"/>
                        </xsl:when>
                        <xsl:otherwise>
                             <i18n:text i18n:key="SKIN_EXPLORER_FOLDER_ALL_DOCUMENTS" i18n:catalogue="skin.{$skin}"/>
                        </xsl:otherwise>
                     </xsl:choose>
                 </span>
            </a>
       </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>		
