<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
     
     <xsl:variable name="header" select="/search/header/text()"/>
     
     <!-- +
          | Common templates for search service used as filtered contents on home page (no criteria, no facets, no pagination)
          + -->
          
     <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="service-header"/>
        
        <xsl:call-template name="form-criteria"/>
        
        <xsl:call-template name="search-results"/>
    </xsl:template>
    
     <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}" style="display:none">
            <!-- Empty form -->
        </form> 
     </xsl:template>
     
     <xsl:template name="service-header">
        <div class="flex">
            <xsl:choose>
                <xsl:when test="$header != ''">
                    <h1 class="service-title"><xsl:copy-of select="/search/header/text()"/></h1>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">flex no-title</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:call-template name="service-header-link"/>
        </div>      
     </xsl:template>
     
     <xsl:template name="service-header-link">
        <xsl:if test="/search/link/page">
            <div class="right">
                <xsl:call-template name="link"/> 
            </div>
        </xsl:if>
     </xsl:template>
     
     <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
</xsl:stylesheet>