<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>        
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/> 
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-css-class-name">container-actu</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function(){
                $j('.carousel-actu').owlCarousel({
    	            loop: true,
    	            margin: 10,
                    autoplay:true, // auto play activated
                    autoplayTimeout:3000, // 3s interval
                    autoplayHoverPause:true, // pause on mouse hover
    	            nav: false,
    	            dots: true,
    	            responsive: {
    	                0: {
    	                    items: 1
    	                }
    	            }
    	        })
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="form-criteria"/>
        
        <xsl:call-template name="search-results"/>
        
        <xsl:call-template name="link"/>
    </xsl:template>
    
    <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
	
    <xsl:template name="hits">
        <div data-ametys-search-role="hits">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <xsl:apply-templates select="."/>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href"><xsl:call-template name="link-href"/></xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <span class="plus">+</span>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
        	<xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>carousel-actu owl-carousel<xsl:text> </xsl:text>
    </xsl:template>
    
</xsl:stylesheet>