<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="skin://services/web/pages/services/search/search-default.xsl"/> 
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>            
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="service-search">
            <xsl:call-template name="form-criteria"/>
            <xsl:call-template name="search-main-content"/>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-title">
        <h1><i18n:text i18n:key="SKIN_SERVICE_SEARCH_NO_CRITERIA_FILTERS_TITLE" i18n:catalogue="skin.{$skin}"/></h1>
    </xsl:template>
    
    <!-- No result count for this view -->
    <xsl:template name="results-count"/>
    
    <!-- Form criteria not supported in this view -->
    <xsl:template name="form-criteria">
        <form method="post" class="searchForm" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
        </form>
    </xsl:template>
    
</xsl:stylesheet>