<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    
    <xsl:template name="common-service-head-css">
  		<link type="text/css" rel="stylesheet" href="{ametys:skinURL('plugins/css/multiselect.css')}"/> 
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
    	<script src="{ametys:skinURL('plugins/js/multiselect.js')}"></script>
        
        <script type="text/javascript">
            $j(document).ready(function () {
                $j('.service-search .top form select[multiple]').each(function (){
                    var $this = $j(this);
                    $this.multiselect({
                        columns: 4,
                        texts: {
                            placeholder: $this.closest('.field').find('label').text(),
                            selectedOptions: ' <i18n:text i18n:key="SKIN_SERVICE_SEARCH_SELECTED_OPTS" i18n:catalogue="skin.{$skin}"/>'
                        }
                    });
                })
                
                
                $j('.service-search .top form.searchForm .field > input').each(function (){
                    var $this = $j(this);
                    if (!$this.attr("placeholder"))
                    {
                        $this.attr('placeholder',  $this.closest('.field').find('label').text());
                    }
                });
            });
        </script>
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name">search view-main</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="service-search">
            <xsl:call-template name="search-main-banner"/>
            <xsl:call-template name="search-main-content"/>
        </div>
    </xsl:template>
    
    <xsl:template name="search-main-banner">
        <div class="top">
            <!-- <xsl:call-template name="quick-access"/> -->
            <div class="container">
                <xsl:call-template name="main-banner-breadcrumb"/>
                
                <div class="title-classic">
                    <h1><xsl:value-of select="$header"/></h1>
                </div>
                
                <xsl:call-template name="form-criteria"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-main-content">
        <xsl:call-template name="anchor" />
        <div class="content">
	        <xsl:call-template name="noscript"/>
            <xsl:call-template name="search-results"/>
        </div>
        <script type="text/javascript">
            $j(document).ready(function() {
                var headerHeight = $j('header').height() + $j(".sticky-menu").height();
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('display', 'block');
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('position', 'relative');
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('top', -headerHeight + 'px');
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>