<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
        
    <!-- The placeholder for fulltext search field -->
    <xsl:variable name="searchInputPlaceholder" select="ametys:serviceViewParameter('searchInputPlaceholder')"/>
    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for  "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
	<xsl:template name="form-criteria">
    	<xsl:call-template name="js-sumit-bo"/>
    	
		<form method="post" class="searchForm" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
			<xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
			<xsl:call-template name="top-search-input"/>
			<xsl:call-template name="top-search-submit"/>
		</form>
    </xsl:template>
    
    <xsl:template name="form-criteria-hidden">
        <form hidden="hidden" data-ametys-search-role="form-criteria-hidden">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:for-each select="/search/form/values/criterion[@name = current()/@name]">
                    <input type="hidden" name="{@name}" value="{.}"/>
                </xsl:for-each>
            </xsl:for-each>
        </form>
    </xsl:template>
    
    <xsl:template name="top-search-input">
        <xsl:for-each select="/search/form/fields/criterion">
        	<xsl:apply-templates select="." mode="field">
                <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field">
        <xsl:param name="value"/>
        
        <!-- The selected criterion will be replaced by a facet choice -->
        <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', @definition)"></xsl:value-of></xsl:variable>
            
        <xsl:variable name="options">
            <items>
                <xsl:for-each select="enumeration/item">
                    <xsl:sort select="label" />
                    
                    <xsl:variable name="itemValue" select="@value" />
                    <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                    <xsl:if test="$compute-counts = 'false' or $count">
                        <item value="{$itemValue}" id="{generate-id()}">
                            <xsl:if test="$count"><xsl:attribute name="count"><xsl:value-of select="$count" /></xsl:attribute></xsl:if>
                            <xsl:copy-of select="label" />
                        </item>
                    </xsl:if>
                 </xsl:for-each>
            </items>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($options)/items/item">
	        <div class="field select-container">
	            <xsl:apply-templates select="." mode="field-label"/>
	                
	            <xsl:apply-templates select="." mode="field-input">
	                <xsl:with-param name="value" select="$value"/>
	                <xsl:with-param name="options" select="exsl:node-set($options)"/>
	            </xsl:apply-templates>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="field search">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <!-- Override to allow placeholder -->
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" class="text">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:choose>
            <xsl:when test="$searchInputPlaceholder != ''">
                <xsl:attribute name="placeholder"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_INPUT_PLACEHOLDER_LABEL</xsl:attribute>
                <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <select id="{$id}" name="{@name}" multiple="multiple">
            <xsl:apply-templates select="." mode="criterion-enumeration-select"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-all-option"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-none-option"/>
        </select>
    </xsl:template>
    
    
    <xsl:template match="criterion" mode="field-label">
        <label class="sr-only"><xsl:value-of select="label"/></label>
    </xsl:template>
    
    <xsl:template name="top-search-submit">
        <div class="search-button">
		 <xsl:if test="/search/launch-search-at-startup = 'false' or count(/search/form/fields/criterion) > 0">
            <xsl:if test="/search/result-display-type = 'ON_PAGE'">
                <input type="hidden" name="submit-form">
                    <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                        <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
                    </xsl:if>
                </input>
            </xsl:if>
            
	       <button type="submit" class="btn">
	       		<xsl:attribute name="onclick" ><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
	            <i18n:text i18n:key="SKIN_SERVICE_SEARCH_FORM_SUBMIT" i18n:catalogue="skin.{$skin}"/>
	        </button>
        </xsl:if>
        </div>
    </xsl:template>
    
</xsl:stylesheet>