<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/results/facets.xsl"/>
    
    <xsl:template name="search-sidebar">
        <xsl:if test="/search/hits/hit and /search/form/facets/facet[@total > 0]">
            <div class="sidebar-filter">
                <xsl:call-template name="close-filter"/>
                <xsl:call-template name="facet-filter"/>
                
                <script>
                    function openExpandable(nb, el) {
                        $j(`[data-expandable="${nb}"]`).toggleClass('open');
    
                        if ($j(`[data-expandable="${nb}"]`).hasClass('open')) {
                            $j(`[data-expandable="${nb}"]`).slideDown();
                            $j(el).find('span').css('transform', 'rotate(180deg)');
                        } else {
                            $j(`[data-expandable="${nb}"]`).slideUp();
                            $j(el).find('span').css('transform', 'rotate(0deg)');
                        }
                    }
                </script>
            </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="close-filter">
        <div class="close" onclick="closeFilter()">
            <span class="material-icons">close</span>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter">
        <xsl:if test="/search/hits/hit and /search/form/facets/facet[@total > 0]">
           <xsl:variable name="unique" select="concat('search-facet-', substring-after(math:random(), '.'))"/>
           <xsl:call-template name="facet-filter-title"/>
           
           <xsl:for-each select="/search/form/facets/facet[@total > 0]">
                <xsl:variable name="searchFilterItemId" select="concat('searchFilterItem-', generate-id())"/>
                
                <xsl:call-template name="facet-filter-header">
                    <xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
                </xsl:call-template>
                
                <xsl:call-template name="facet-filter-elements">
                    <xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
                    <xsl:with-param name="name" select="@name"/>
                </xsl:call-template>
           </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facet-filter-header">
        <xsl:param name="searchFilterItemId" />
        
        <div class="title" onclick="openExpandable(1, this)">
            <section>
                <xsl:call-template name="facet-filter-icon"/>
                <xsl:value-of select="label"/>
            </section>
            <span class="material-icons" style="transform: rotate(180deg);">expand_more</span>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-icon">
        <xsl:choose>
            <xsl:when test="contains(@name, 'ContentType')">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="512px" height="513px" viewBox="0 0 512 513" version="1.1" class="svg replaced-svg">
                    <title>contenu</title>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="Desktop" transform="translate(0.000000, -478.000000)" fill="#f1f1f1" fill-rule="nonzero">
                            <g id="icons" transform="translate(0.000000, 43.105692)">
                                <g id="contenu" transform="translate(0.000000, 434.900123)">
                                    <path d="M100,113 C100,102 109,93 120,93 L392,93 C403,93 412,102 412,113 C412,124 403,133 392,133 L120,133 C109,133 100,124 100,113 Z M412,193 C412,182 403,173 392,173 L120,173 C109,173 100,182 100,193 C100,204 109,213 120,213 L392,213 C403,213 412,204 412,193 Z M120,253 C109,253 100,262 100,273 C100,284 109,293 120,293 L212,293 C223,293 232,284 232,273 C232,262 223,253 212,253 L120,253 Z M494.4,409.6 C517.8,433 517.8,471 494.4,494.4 C482.7,506.1 467.4,512 452,512 C436.6,512 421.3,506.1 409.6,494.5 L300.2,384.9 C297.8,382.5 296,379.4 295.1,376.1 L272.7,295.4 C270.8,288.4 272.8,280.8 278,275.7 C283.2,270.6 290.8,268.8 297.8,270.9 L376.5,294.8 C379.7,295.8 382.5,297.5 384.8,299.8 L494.4,409.6 Z M332.2,360.3 L405.7,434 L434,405.7 L360.1,331.6 L321,319.7 L332.2,360.3 Z M466.1,437.9 L462.2,434 L434,462.3 L437.9,466.2 C445.7,474 458.4,474 466.2,466.2 C473.9,458.3 473.9,445.7 466.1,437.9 Z M432,0 L80,0 C35.9,0 0,35.9 0,80 L0,432 C0,476.1 35.9,512 80,512 L325,512 C336,512 345,503 345,492 C345,481 336,472 325,472 L80,472 C57.9,472 40,454.1 40,432 L40,80 C40,57.9 57.9,40 80,40 L432,40 C454.1,40 472,57.9 472,80 L472,326 C472,337 481,346 492,346 C503,346 512,337 512,326 L512,80 C512,35.9 476.1,0 432,0 Z" id="Shape"></path>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
            </xsl:when>
            <xsl:otherwise>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="513px" height="398px" viewBox="0 0 513 398" version="1.1" class="svg replaced-svg">
                    <title>categorie</title>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="Desktop" transform="translate(0.000000, -535.000000)" fill="#f1f1f1" fill-rule="nonzero">
                            <g id="icons" transform="translate(0.000000, 43.105692)">
                                <g id="categorie" transform="translate(0.000000, 491.900123)">
                                    <path d="M506,180.5 C498.2,167.9 484.5,160.5 469.2,160.5 L431.1,160.5 L431.1,90.6 C431.1,73.7 416.9,60 399.4,60 L213,60 C212.7,60 212.5,59.9 212.5,59.9 L179.1,13.2 C173.2,4.9 163.4,0 153,0 L31.7,0 C14.2,0 0,13.7 0,30.6 L0,365.7 C0,383 14.6,397 32.5,397 L409.9,397 C415.8,397 420.9,393.6 423.3,388.7 L423.3,388.7 L507.9,218.9 C514,206.6 513.3,192.2 506,180.5 Z M31.7,30 L153,30 C153.9,30 154.5,30.4 154.7,30.7 L188.1,77.4 C193.7,85.3 203,90 213,90 L399.4,90 C400.4,90 401,90.5 401.1,90.7 L401.1,160.5 L129.7,160.5 C112.9,160.5 97.6,170 90.7,184.7 L30,314.5 L30,30.7 C30.1,30.5 30.7,30 31.7,30 Z M481,205.5 L400.6,367 L38.6,367 L117.9,197.3 C119.8,193.2 124.6,190.4 129.7,190.4 L469.3,190.4 C474.1,190.4 478.3,192.6 480.6,196.2 C481.8,198.3 482.9,201.6 481,205.5 Z" id="Shape"></path>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="facet-filter-title">
        <h2><i18n:text i18n:key="SKIN_SERVICE_SEARCH_FILTERS_TITLE" i18n:catalogue="skin.{$skin}"/></h2>
    </xsl:template>
    
     <xsl:template name="facet-filter-elements">
        <xsl:param name="searchFilterItemId" />
        <xsl:param name="moreIndex">5</xsl:param>
        
        <xsl:variable name="facetPrefixId">
            <xsl:call-template name="facet-filter-element-prefix-id">
                <xsl:with-param name="facetName" select="@name"/>
            </xsl:call-template>
        </xsl:variable>
        
        <div class="expandable">
            <div class="list-checkbox open" data-expandable="1" style="display: block;" data-ametys-search-role="facet-filter" data-ametys-search-facet-name="{current()/@name}">
                <xsl:for-each select="item[@count > 0]">
                    <xsl:sort select="@count" data-type="number" order="descending"/>
                    
                    <xsl:call-template name="facet-filter-element">
                        <xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
                        <xsl:with-param name="facetPrefixId" select="$facetPrefixId"/>
                    </xsl:call-template>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-element">
        <xsl:param name="searchFilterItemId" />
        <xsl:param name="facetPrefixId">facet-</xsl:param>
        
        <xsl:variable name="id" select="concat($facetPrefixId, translate(@value, ':/', ''))"/>
        <div class="item-checkbox">
            <xsl:variable name="onclick"><xsl:call-template name="search-js-facet"/></xsl:variable>
            <input type="checkbox" name="{../@name}" value="{@value}" onclick="{$onclick}" id="{$id}">
                <xsl:choose>
                    <xsl:when test="@selected = 'true'">
                        <xsl:attribute name="data-ametys-search-role">facet-selected</xsl:attribute>
                        <xsl:attribute name="checked">checked</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="data-ametys-search-role">facet-unselected</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </input>
            <label for="{$id}">
                <xsl:choose>
                    <xsl:when test="text()">
                       <xsl:value-of select="text()"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- CMS-10799 Tag facets has no label (for version 4.6.0 or lower)-->
                        <xsl:variable name="tagLabel" select="ametys:tagLabel($site, @value, $lang)"/>
                        <xsl:value-of select="$tagLabel"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text> </xsl:text> (<xsl:value-of select="@count"/>)</label>
        </div>
    </xsl:template>
    
    <xsl:template name="facet-filter-element-prefix-id">
        <xsl:param name="facetName"/>
        
        <xsl:value-of select="concat('facet-', generate-id(), '-')"/>
    </xsl:template>
</xsl:stylesheet>