<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">display-articles-section</xsl:variable>
    
    <xsl:template name="service-header">
        <xsl:if test="$header != ''">
            <h1 class="service-title"><xsl:copy-of select="/search/header/text()"/></h1>
        </xsl:if>
    </xsl:template>
   
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/display-articles/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
   
    <xsl:template name="hits">
        <ul class="display-articles-section-list" data-ametys-search-role="hits">
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </ul>
        
        <xsl:call-template name="link"/>
    </xsl:template>
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute"/>

    <!-- Override to delete div  -->
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    
     <!-- Override to change class -->
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn white">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="no-result">
        <div class="no-result" data-ametys-search-role="no-result">
            <i18n:text i18n:key="SKIN_SERVICE_SEARCH_INFORMATION_NORESULT" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
</xsl:stylesheet>