<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    <xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-css-class-name">kiosque-section</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/zone_kiosque.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            $j(document).ready(function(){
                var owlKiosque = $j('.kioske').owlCarousel({
                    loop: false,
                    margin: 10,
                    nav: false,
                    dots: true,
                    slideBy: 1,
                    autoplay: false,
                    responsive: {
                        0: {
                            items: 1,
                            slideBy: 1
                        },
                        500: {
                            items: 2,
                            slideBy: 1
                        },
                        700: {
                            items: 3,
                            slideBy: 1
                        },
                        1024: {
                            items: 4,
                            slideBy: 1
                        },
                        1200: {
                            items: 5,
                            slideBy: 1
                        }
                    }
                })
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="kioske owl-carousel">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
        
        <xsl:call-template name="link-mobile"/> 
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>kioske-item item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn desktop">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-mobile">
        <xsl:if test="/search/link/page">
            <xsl:call-template name="link-tag-mobile"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag-mobile">
        <xsl:if test="/search/link/page">
            <a class="btn mobile">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>