<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
	<xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>          
	<xsl:import href="skin://services/web/pages/services/search/common/home-search.xsl"/>
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
    <xsl:variable name="common-service-css-class-name"> actu-perso</xsl:variable>
    
    <xsl:variable name="callback-function">initializeNewsPersoSearch</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/actu-perso/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min.js')}" />
        
        <script type="text/javascript">
            function launchNewsPersoCarousel(){
                var owlKiosque = $j('.actu-perso-container').owlCarousel({
                    loop: false,
                    margin: 10,
                    nav: false,
                    dots: true,
                    slideBy: 1,
                    autoplay: false,
                    responsive: {
                        0: {
                            items: 1,
                            slideBy: 1
                        },
                        500: {
                            items: 2,
                            slideBy: 1
                        },
                        700: {
                            items: 3,
                            slideBy: 1
                        },
                        1024: {
                            items: 4,
                            slideBy: 1
                        },
                        1200: {
                            items: 5,
                            slideBy: 1
                        }
                    }
                })
            };
            
	        function openDropdownPersonnalize() {
	            $j('.dropdown-personnalize').show();
	        }
	
	        function closeDropdownPersonnalize() {
	            $j('.dropdown-personnalize').hide();
	        }
	
	        setTimeout(function () {
	            document
	                .querySelector(".dropdown-personnalize")
	                .addEventListener("click", function getDetails(evt) {
	                    evt.stopPropagation();
	                });
	
	            document
	                .querySelector(".personnalize-link")
	                .addEventListener("click", function getDetails(evt) {
	                    evt.stopPropagation();
	                });
	
	
	            document.addEventListener("click", function (e) {
	                closeDropdownPersonnalize();
	            });
	        }, 500);
	        
            $j(document).ready(function() {
               initializeNewsPersoSearch();
            });
            
	        function initializeNewsPersoSearch() {
	            checkTags();
	            launchNewsPersoCarousel();
	        }
            
            function cropTextToMaxWidth(text, maxWidth) {
                const offScreenElement = document.createElement('span');
                offScreenElement.style.visibility = 'hidden';
                offScreenElement.style.position = 'absolute';
                offScreenElement.style.whiteSpace = 'nowrap';
                offScreenElement.style.font = 'inherit';
                offScreenElement.textContent = text;
                document.body.appendChild(offScreenElement);

                const textWidth = offScreenElement.offsetWidth;

                document.body.removeChild(offScreenElement);

                if (textWidth > maxWidth) {
                    const croppedText = text.slice(0, Math.floor((maxWidth / textWidth) * text.length));
                    return croppedText + '...';
                }

                return text;
            }
	        
	         function checkTags() {
	             setTimeout(function () {
	                 $j('.actu-perso-item').each(function() {
                            const widthItem = $j(this).width();
                            const tags = $j(this).find(".tags .tag:not('.count')");
                            let widthTags = 0;
                            let additionnalWidth = 0;
                            if (tags.length > 1) {
                                additionnalWidth = 26;
                            }
                            $j(tags).each(function() {
                                widthTags += $j(this).width() + additionnalWidth;
                            });
                            widthTags = widthTags + 50;

                            if (widthTags > widthItem) {
                                let tagText = '';
                                let widthTagIncrement = 0;
                                let countTagHide = 0;
                                $j(tags).each(function(index) {
                                    widthTagIncrement += $j(this).width() + additionnalWidth;
                                    if (widthTagIncrement + 50 > widthItem) {
                                        if (index === 0 &amp;&amp; tags.length == 1) {
                                            const text = $j(this).text();
                                            $j(this).text(cropTextToMaxWidth(text, 140));
                                        } else if (index === 0 &amp;&amp; tags.length > 1) {
                                            const text = $j(this).text();
                                            $j(this).text(cropTextToMaxWidth(text, 90));
                                        } else {
                                            $j(this).hide();
                                            tagText += $j(this).text() + ', ';
                                            countTagHide++;
                                        }
                                    }
                                });
                                tagText = tagText.slice(0, -2);
                                if (countTagHide > 0 &amp;&amp; !$j(this).find('.tags .tag.count').length) {
                                    $j(this).find('.tags').append(`&lt;span data-tippy-content="${tagText}" class="tag count">+${countTagHide}&lt;/a>`);
                                    
                                    tippy('.tags [data-tippy-content]', {});
                                }
                            }
                        });
	         }, 30);
	     }
	    </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="container">
	        <xsl:call-template name="service-header"/>
	        
	        <xsl:call-template name="search-results"/>
        </div>
    </xsl:template>
    
    <xsl:template name="service-header-link">
        <div class="flex-div">
            <xsl:call-template name="form-criteria"/>
            <xsl:call-template name="link"/> 
        </div>
    </xsl:template>
    
    <!-- Override form-search: only tag criteria is supported ! -->
    <xsl:template name="form-search">
        <xsl:if test="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]">
             <xsl:call-template name="form-criteria-header"/>
             
             <div class="dropdown-personnalize">
                <xsl:call-template name="criteria-dropdown-icon"/>
                <div class="dropdown-content">
                    <xsl:apply-templates select="/search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="field">
                        <xsl:with-param name="value" select="/search/form/values/criterion[@name = /search/form/fields/criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]/@name]"/>
                    </xsl:apply-templates>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form-criteria-header">
        <a href="javascript:void(0)" onclick="openDropdownPersonnalize()" class="personnalize-link">
          <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="form-criteria-icon"/>
            <i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_LINK" i18n:catalogue="skin.{$skin}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="criteria-dropdown-icon">
        <div class="dropdown-icons">
            <i class="fas fa-ellipsis-h"></i>
            <i class="fa fa-times close" onclick="closeDropdownPersonnalize()" aria-hidden="true"></i>
        </div>
    </xsl:template>
    
    <xsl:template name="form-criteria-icon">
        <svg id="icon-reglages" xmlns="http://www.w3.org/2000/svg" width="46" height="46"
            viewBox="-3 -3 46 46">
            <defs>
            </defs>
            <rect id="Rectangle_arrondi_560_copie" data-name="Rectangle arrondi 560 copie" class="cls-1"
                width="40" height="40" rx="20" ry="20" />
            <path id="reglages" class="cls-2"
                d="M1286.18,1241.36a3.1,3.1,0,1,0-3.09,3.09A3.094,3.094,0,0,0,1286.18,1241.36Zm4.47-3.1a3.1,3.1,0,1,0,3.09,3.1A3.094,3.094,0,0,0,1290.65,1238.26Zm-15.13,0a3.1,3.1,0,1,0,3.1,3.1A3.094,3.094,0,0,0,1275.52,1238.26Z"
                transform="translate(-1263 -1221)" />
        </svg>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="field">
        <xsl:param name="value"/>
        
        <div class="list-checkbox">
            <xsl:apply-templates select="." mode="field-label"/>
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="field-label">
        <div class="dropdown-title"><i18n:text i18n:key="SKIN_SEARCH_ACTUS_PERSONNALIZE_THEMATIQUES" i18n:catalogue="skin.{$skin}"/></div>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/criteria.xsl : only tag criteria is supported ! -->
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.ContentSearchable$systemProperty$tags')]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="criterion-name" select="@name"/>
        
             <xsl:for-each select="enumeration/item">
                <xsl:sort select="label" />
                
                <div class="item-checkbox">
                     <xsl:variable name="id-checkbox"><xsl:call-template name="criterion-id"/></xsl:variable>
                     <xsl:variable name="onclick">
                        <xsl:call-template name="search-js-submit-button"/>
                    </xsl:variable>
                
                    <input onchange="{$onclick}" id="{$id-checkbox}-{position()}" type="checkbox" name="user.input.criterion.ContentSearchable$systemProperty$tags$1" value="{@value}">
                      <xsl:if test="$value = @value">
                            <xsl:attribute name="checked">checked</xsl:attribute>
                      </xsl:if>
                    </input>
                        
                   <label for="{$id-checkbox}-{position()}" class="checked">
                       <xsl:value-of select="label"/>
                   </label>
                </div>
            </xsl:for-each>
    </xsl:template>
    
     <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="actu-perso-container owl-carousel">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <span class="plus">+</span>
                <xsl:call-template name="link-attribute"/>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>actu-perso-item <xsl:text> </xsl:text>
    </xsl:template>
    
    
</xsl:stylesheet>