<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:math="java.lang.Math"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys math">
    
    <xsl:import href="skin:intranet://services/web/pages/services/search/search-documents.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">webtv-section</xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/webtv/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="hits">
        <div class="webtv-grid" data-ametys-search-role="hits">
            <xsl:choose>
                <xsl:when test="/search/hits/hit">
                    <xsl:for-each select="/search/hits/hit">
                        <xsl:call-template name="hit"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="/search/hits">
                    <xsl:call-template name="no-result"/>
                </xsl:when>
            </xsl:choose>
        </div>
        
        <xsl:call-template name="link-mobile"/> 
    </xsl:template>

    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>webtv-grid-item<xsl:text> </xsl:text>
    </xsl:template>
    
</xsl:stylesheet>