<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
        extension-element-prefixes="resolver">

    <xsl:import href="plugin:workspaces://pages/services/projects/my-projects/my-projects.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">community</xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/community/scss/main.css')}"/>
    </xsl:template>
    
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="projects-js"/>
        
        <!-- TOOLTIP -->
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/poppers.min.js')}" />
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/tippy-bundle.umd.min')}" />
        
        <script type="text/javascript">
            $j(document).ready(function(){
            
                window.VEvent.listen("projects-opened", function(data) {
                    Projects.open("#projects-<xsl:value-of select="$uniqueId"/>");
                })
                
                window.VEvent.listen("projects-loading", function(data) {
                    // Show loader
                    $j('.community__feed__loader').addClass('open');
                })
                
                window.VEvent.listen("projects-loaded", function(data) {
                    // Hide loader
                    $j('.community__feed__loader').removeClass('open');
                    
                    // Handle favorites
                    $j('.ametys-projects-favorite').on('click', function() {
                    
                        const isFavorite = $j(this).attr('data-project-favorite') == 'true';
                        const projectName = $j(this).attr('data-project-name');
                
                        Projects.setFavorite(projectName, !isFavorite, function (success) {
                            if (success)
                            {
                                // Reload projects
                                Projects.open("#projects-<xsl:value-of select="$uniqueId"/>", null, true /*force*/);
                            }
                        })             
                    });
                    
                    // Check if tooltip is needed
                    $j(".community .ametys-q-panel__list_tmd").each(function () {
                      
                      if ($j(this)[0].offsetHeight + 10 &lt; $j(this)[0].scrollHeight) 
                      {
                          $j(this).find("a").attr("data-tippy-content", $j(this).find("a").text());
                      }
                    });
                    
                    // Create tooltips
                    tippy('[data-tippy-content]', {});
                });
                
            });
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
        
        <h1 class="service-title"><xsl:value-of select="$title"/></h1>
   </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="projects-{$uniqueId}">
            <div class="community__flex">
                <xsl:call-template name="projects-filter"/>
                
                <!-- Not yet implemented -->
                <!--<xsl:call-template name="create-project-btn"/>-->
            </div>
            
            <div class="community__feed">
                <xsl:call-template name="projects-loader"/>
                
                <div class="community__feed__wrapper">
                    <div data-ametys-projects-role="results">
                        <!-- Projects will be inserted here -->
                    </div>
                    
                    <!-- No result -->
                    <xsl:call-template name="no-result"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="projects-loader">
        <div class="community__feed__loader">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="51px" height="51px"
                viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                <circle cx="50" cy="50" fill="none" stroke="#0a0a0a" stroke-width="10" r="35" stroke-dasharray="164.93361431346415 56.97787143782138">
                    <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" values="0 50 50;360 50 50" keyTimes="0;1"></animateTransform>
                </circle>
            </svg>
        </div>
    </xsl:template>
    
    <xsl:template name="no-result">
        <div data-ametys-projects-role="no-result" class="no-result" style="display: none">
            <i18n:text i18n:key="SKIN_SERVICE_MY_PROJECTS_NO_RESULT" i18n:catalogue="skin.{$skin}"/>
        </div>
    </xsl:template>
    
    <xsl:template name="create-project-btn">
        <a href="#" class="community__flex__create"><i18n:text i18n:key="SKIN_SERVICE_MY_PROJECTS_CREATE_PROJECT" i18n:catalogue="skin.{$skin}"/> <i class="fas fa-plus"></i></a>
    </xsl:template>
    
    <xsl:template name="projects-filter">
        <form class="community__filter" data-ametys-projects-role="filters">
            <xsl:call-template name="filter-search-icon"/>
            
            <!-- Input text -->
            <input type="text" class="community__filter__input" name="pattern" placeholder="skin.{$skin}:SKIN_SERVICE_MY_PROJECTS_FILTER_PLACEHOLDER" title="skin.{$skin}:SKIN_SERVICE_MY_PROJECTS_FILTER_PLACEHOLDER" i18n:attr="placeholder title" />
            <button type="button" title="skin.{$skin}:SKIN_SERVICE_MY_PROJECTS_FILTER_PLACEHOLDER" i18n:attr="title" aria-expanded="false" onclick="openFilter_{$uniqueId}(this)"><i class="fa fa-chevron-down" aria-hidden="true"></i></button>
            
            <div class="commmunity__filter__count">0</div>
            
            <xsl:call-template name="filter-dropdown"/>
        </form>
        
        <xsl:call-template name="projects-filter-js"/>
     </xsl:template>
     
     <xsl:template name="filter-search-icon">
        <svg aria-hidden="true" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <title>E02DBFDF-F11A-4272-8824-8A024B4F7191</title>
            <g id="Produit" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g transform="translate(-142.000000, -254.000000)" fill="#795198" fill-rule="nonzero" id="workspace">
                    <g transform="translate(65.000000, 160.000000)">
                        <g id="Filtre" transform="translate(57.000000, 84.000000)">
                            <g id="ICON-LOUPE" transform="translate(20.000000, 10.000000)">
                                <path d="M21.152057,16.6163471 C24.9493143,12.8203129 24.9493143,6.64305977 21.152057,2.84702562 C17.3547996,-0.949008539 11.1755559,-0.949008539 7.37829851,2.84702562 C4.15333654,6.07094872 3.66611207,10.8565804 5.9166251,14.5984959 C5.9166251,14.5984959 6.07903325,14.869089 5.86248905,15.0855634 C4.61735984,16.3302915 0.889705954,20.0567446 0.889705954,20.0567446 C-0.100210431,21.0463421 -0.332222084,22.4302324 0.541688475,23.3038614 L0.69636291,23.458486 C1.57027347,24.3321151 2.95460966,24.1001781 3.94452605,23.1105807 C3.94452605,23.1105807 7.66444622,19.3918588 8.9018417,18.1548619 C9.13385335,17.922925 9.39679989,18.0852809 9.39679989,18.0852809 C13.1399212,20.3196065 17.927095,19.8325389 21.152057,16.6163471 Z M9.17252196,14.8149704 C6.36518096,12.0085337 6.36518096,7.44710774 9.17252196,4.64067108 C11.979863,1.83423443 16.5427588,1.83423443 19.3500998,4.64067108 C22.1574408,7.44710774 22.1574408,12.0085337 19.3500998,14.8149704 C16.5427588,17.621407 11.979863,17.621407 9.17252196,14.8149704 Z" id="Shape"></path>
                                <path d="M10.0087625,10 C9.87716375,10 9.74556499,9.9735209 9.61396624,9.91173632 C9.10305344,9.664598 8.86307924,8.99379401 9.07983013,8.4112537 C10.4422643,4.73948448 14.1657349,3.01834266 17.3860338,4.57178348 C17.8969466,4.8189218 18.1369208,5.48972579 17.9201699,6.0722661 C17.703419,6.65480641 17.1150952,6.92842382 16.6041823,6.68128551 C14.4057091,5.62212131 11.8666272,6.7960283 10.9376949,9.3027169 C10.7673906,9.73520895 10.3958177,10 10.0087625,10 Z" id="Path"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="filter-dropdown">
        <div class="filter-projects-dropdown">
            <div class="filter-projects-dropdown-list">
                <!-- All option (clear filters) -->
                <xsl:call-template name="filter-all-option"/>
                
                <!-- Themes -->
                <xsl:call-template name="filter-categories"/>
            </div>
        </div>
        
        <script>
            $j(".filter-projects-show-more").on('click', function () {
                const dataIsMore = $j(this).attr('data-is-more');
                const dataShowMore = $j(this).attr('data-show-more');
                
                if(dataIsMore == "false") {
                    $j(`.filter-projects-dropdown .filter-projects-dropdown-item input[name='${dataShowMore}']`).parent().show();
                    $j(this).attr('data-is-more', 'true');
                    $j(this).attr('aria-expanded', 'true');
                    $j(this).text('<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_LESS" i18n:catalogue="skin.{$skin}"/>');
                } else {
                    $j(`.filter-projects-dropdown .filter-projects-dropdown-item input[name='${dataShowMore}']:gt(4)`).parent().hide();
                    $j(this).attr('data-is-more', 'false');
                    $j(this).attr('aria-expanded', 'false');
                    $j(this).text('<i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>');
                }
            });
        </script>
    </xsl:template>
    
    <xsl:template name="filter-all-option">
         <div class="filter-projects-dropdown-item">
            <input class="sr-only" type="checkbox" name="categories" checked="checked" id="projects-filter-all-opt-{$uniqueId}" value=""/> 
            <label for="projects-filter-all-opt-{$uniqueId}"><i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_FILTER_ALL" i18n:catalogue="skin.{$skin}"/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="filter-categories">
        <div class="filter-projects-dropdown-title">
            <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_FILTER_CATEGORIES" i18n:catalogue="skin.{$skin}"/>
        </div>
        
        <xsl:for-each select="/Workspaces/categories/category">
            <xsl:sort select="."/>
            
            <div class="filter-projects-dropdown-item">
                <xsl:if test="position() > 5"><xsl:attribute name="style">display:none;</xsl:attribute></xsl:if>
                <input class="sr-only" type="checkbox" name="categories" id="projects-category-{position()}" value="{@name}"/> 
                <label for="projects-category-{position()}"><xsl:value-of select="."/></label>
            </div>
        </xsl:for-each>
        
        <xsl:if test="count(/Workspaces/categories/category) &gt; 5">
            <button type="button" aria-expanded="false" class="filter-projects-show-more" data-is-more="false" data-show-more="categories">
                <i18n:text i18n:key="SKIN_SERVICE_ACTIVITY_STREAM_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>
            </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="projects-filter-js">   
        <script>
        
            // Open close / filter
            function openFilter_<xsl:value-of select="$uniqueId"/>(btn)
            {
                $j(btn).parent().toggleClass('open');
                var isOpen = $j(btn).parent().hasClass('open');
                $j(btn).attr("aria-expanded", isOpen);
                
                if (isOpen)
                {
                    // place focus into dropdown
                    $j(btn).parent().find('.filter-projects-dropdown input').first().focus();
                }
                return false;
            }
            
            // Close filter
            $j(document).click(function (e) {
                if (
                  $j(e.target).closest(".community__filter").length === 0 &amp;&amp;
                  $j(e.target).closest(".filter-projects-dropdown").length === 0 &amp;&amp;
                  !$j(e.target).is(':button')
                ) {
                  $j(".community__filter").removeClass('open');
                  $j(".community__filter button").attr("aria-expanded", false);
                }
            });
            
            let keyUpTimer_<xsl:value-of select="$uniqueId"/> = null;
            $j(document).on('keyup', '.community__filter input', function() {
                // clear the previous timer
                clearTimeout(keyUpTimer_<xsl:value-of select="$uniqueId"/>);
                
                keyUpTimer_<xsl:value-of select="$uniqueId"/> = setTimeout(() => {
                    let pattern = $(this).val();
                    if ($j(this).val().length >= 3 || pattern == '') {
                        searchOnProjects();
                    } 
                }, 300);
            });
                
            // Handle click on "all" filter option
            $j(".filter-projects-dropdown input[value='']").change(function () {
                const $dropdownList = $j(this).closest('.filter-projects-dropdown');
                
                if ($j(this).is(":checked")) 
                {
                  // unselect all other options if check "all" option
                  $dropdownList
                     .find("input[value!='']")
                     .prop("checked", false);

                  $j('.commmunity__filter__count').text(0);
                  $j('.community__filter').removeClass('filter-active');
                }
                         
                searchOnProjects();
            });
            
              
            $j(".filter-projects-dropdown input[value!='']").change(function () {
                const $dropdownList = $j(this).closest('.filter-projects-dropdown');
                const $allOpt = $dropdownList.find("input[value='']");
                const activeCount = $dropdownList.find("input[value!='']:checked").length;
                
                $j('.commmunity__filter__count').text(0);
                $j('.community__filter').removeClass('filter-active');
                
                if ($allOpt.is(":checked") &amp;&amp; $j(this).is(":checked")) 
                {
                    // unselect "all" option
                    $allOpt.prop("checked", false);
                }
                else if (activeCount == 0)
                {
                    // no option selected => check 'all' option
                    $allOpt.prop("checked", true);
                }
                
                $j('.commmunity__filter__count').text(activeCount);
                activeCount == 0 ? $j('.community__filter').removeClass('filter-active') : $j('.community__filter').addClass('filter-active');

                searchOnProjects();
            });
            
            function searchOnProjects()
            {
                // Reload projects
                Projects.open("#projects-<xsl:value-of select="$uniqueId"/>", null, true /* force */);
            }
        </script>
    </xsl:template>
    
</xsl:stylesheet>