<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="sitemap ametys">

    <xsl:import href="workspace:web://stylesheets/template-default.xsl"/>
    <xsl:import href="skin://stylesheets/main.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
 
    <xsl:param name="lang"/>
    <xsl:param name="skin"/>
    <xsl:param name="site"/>
    <xsl:param name="cms-context"/>
    <xsl:param name="contextPath"/>
    <xsl:param name="template">page</xsl:param>
    <xsl:param name="rendering-context" select="ametys:renderingContext()"/>
    
    <xsl:param name="site-uri-prefix" select="$cms-context"/>
 
    <xsl:template match="/">
        <html lang="{$lang}" xml:lang="{$lang}">
            <head>
                <xsl:call-template name="head-meta-top"/>        
                <title><xsl:call-template name="get-title" /></title>

                <xsl:call-template name="head-js-jquery"/>                      
                <xsl:call-template name="head-js-pirobox"/>   
                <xsl:call-template name="head-js-mediaelement"/>                     
                
                <xsl:call-template name="head-css-jquery"/>                     
                <xsl:call-template name="head-css-pirobox"/>
                <xsl:call-template name="head-css-mediaelement"/>
                
                <xsl:call-template name="meta" />
                <xsl:call-template name="og-meta" />

                <xsl:call-template name="common-css" />
                <xsl:call-template name="additionnal-css" />
                
                <xsl:call-template name="common-script" />
                <xsl:call-template name="additionnal-script" />
                
	            <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
	            <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_interieur.css')}" />
	            
                
                <xsl:copy-of select="/html/head/*[local-name() != 'title' and local-name() != 'meta']"/>
            </head>
            <body>
            	<article class="page-interieur">
		     		<div class="top">
		     			<div class="container">
                            <div class="title">
                                <h1></h1>
                                <div class="white-date"><div class="date-container"></div></div>
                            </div>
                            <div class="image-article"></div>
                		</div>
                	</div>
                    <div class="content">
                	   <xsl:call-template name="main-zone"/>
                    </div>
                </article> 
                
                <xsl:call-template name="wrapper-styles"/> 
                
                <xsl:call-template name="wrapper-js"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="main-zone">
        <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level" select="1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="wrapper-styles">
        <style>
            .ametys-cms-content{ padding: 2em; }
            .page-interieur > .top > .container{ padding-top: 120px !important; }
            
            .cut-image {
                max-width: 500px;
            }
    
              @media screen and (max-width: 1024px) {
                width: 100%;
        
                .cut-image {
                  max-width: 100%;
                }
              }
        </style>
    </xsl:template>
    
    <xsl:template name="wrapper-js">
        <script type="text/javascript">
            $j(document).ready(function () {
                
                // move title to header
                var $title = $(".ametys-cms-content > .ametys-content-title");
                var $subtitle = $(".ametys-cms-content > .ametys-content-subtitle");
                if ($title.length)
                {
                   $j("article .top .container .title h1").html($title.html());
                   if ($subtitle.length)
                   {
                        $j("article .top .container .title h1").after(`&lt;div>&lt;span class="subtitle">${$subtitle.html()}&lt;/span>&lt;/div>`);
                   }
                   $title.remove();
                   $subtitle.remove();
                }
                
                // move date to header
                var $date = $(".ametys-cms-content > .content-date");
                if ($date.length)
                {
                    $j("article .top .container .white-date .date-container").html($date.html());
                    $date.remove();
                }
                else
                {
                    $j("article .top .container .white-date").remove();
                }
                
                // move illustration to header
                var $img = $(".content-illustration img");
                if ($img.length)
                {
                    // Move illustration
                    $img.appendTo("article .top .container .image-article");
                
                    $j('article .top').addClass('has-img');
                    
                    var height = 0;
    
                    var imgArticleHeight = $j('.image-article img').height();
                    var topHeight = $j('article .top').height() - 100;
                    var diff = imgArticleHeight - topHeight - 120;
    
                    if (topHeight > imgArticleHeight) {
                        if ($j(window).width() > 1150) {
                            $j('.image-article').addClass('center');
                        }
                    } else {
                        $j('.ametys-cms-content').children().each(function (i) {
                            if (height &lt; 150) {
                                $j(this).addClass('cut-image');
                            }
                            height += $j(this).height();
                        });
                    }
                }
            });
        </script>
    </xsl:template>
</xsl:stylesheet>