<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
						      xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver ugc">

	<xsl:import href="ads.xsl"/>
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/> 
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    
    <xsl:template name="common-content-body-title-content"/>
    
     <xsl:template name="common-content-body">
         <xsl:choose>
            <xsl:when test="$zone = 'default' or $zone = 'secondary'">
                <div class="ametys-cms-content {$common-content-css-class-name} wrapper">
                    <xsl:call-template name="common-content-body-title"/>
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="page-id"><xsl:call-template name="get-page-id" /></xsl:variable>
                <a href="{resolver:resolve('page', $page-id, false)}">
                    <xsl:call-template name="ads-image"/>
                    <xsl:call-template name="ads-infos"/>
                </a>         
            </xsl:otherwise>
        </xsl:choose>  
    </xsl:template>
    
    <xsl:template name="ads-image">
        <div class="picture">
            <xsl:call-template name="ads-category"/>
            <xsl:call-template name="ads-main-image"/>
        </div>
    </xsl:template>
    
    <xsl:template name="ads-main-image">
        <xsl:param name="maxWidth">250</xsl:param>
        <xsl:param name="maxHeight">195</xsl:param>
        
        <xsl:choose>
            <xsl:when test="metadata/illustrations/image1">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image-smallsize">
                    <xsl:with-param name="image" select="metadata/illustrations/image1"/>
                    <xsl:with-param name="alternative" select="metadata/illustrations/image1/alt-text"/>
                    <xsl:with-param name="maxWidth" select="$maxWidth"/>
                    <xsl:with-param name="maxHeight" select="$maxHeight"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>  
             </xsl:when>
             <xsl:otherwise>
                <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/annonce.svg')}"/>
             </xsl:otherwise>
          </xsl:choose>
    </xsl:template>
    
    <xsl:template name="ads-category">
        <xsl:if test="metadata/category">
            <span class="tag">
                <xsl:if test="not(metadata/illustrations/image1)">
                    <xsl:attribute name="class">tag blue</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="metadata/category/@title"/>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-infos">
        <div class="info">
            <div>
                <xsl:call-template name="ads-date"/>
                <xsl:call-template name="ads-title"/>
            </div>
            <xsl:call-template name="ads-price"/>
        </div>
    </xsl:template>
    
    <xsl:template name="ads-date">
        <div class="date-container">
            <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="@createdAt"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="ads-title">
        <span class="title trunk2">
            <xsl:value-of select="metadata/title"/>
        </span>
    </xsl:template>
    
    <xsl:template name="ads-price">
        <xsl:if test="metadata/price and metadata/price != '0.0'">
            <div class="price-container">
                <span class="material-icons">chevron_right</span>
                <span class="price">
                    <xsl:choose>
                        <xsl:when test="contains(metadata/price, '.0')"><xsl:value-of select="substring-before(metadata/price, '.0')"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="translate(metadata/price, '.', ',')"/></xsl:otherwise>
                    </xsl:choose>
                    <xsl:text> </xsl:text>
                    <i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_PRICE_UNIT" i18n:catalogue="skin.{$skin}"/>
                </span>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <xsl:choose>
            <xsl:when test="metadata/illustrations/image1">
                <!-- Image -->
                <xsl:call-template name="common-content-body-image-smallsize">
                    <xsl:with-param name="image" select="metadata/illustrations/image1"/>
                    <xsl:with-param name="alternative" select="metadata/illustrations/image1/alt-text"/>
                    <xsl:with-param name="maxWidth" select="'235'"/>
                    <xsl:with-param name="maxHeight" select="'142'"/>
                    <xsl:with-param name="type" select="'cropped'"/>
                </xsl:call-template>  
             </xsl:when>
             <xsl:otherwise>
                <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/annonce.svg')}"/>
             </xsl:otherwise>
          </xsl:choose>
    </xsl:template>
    
    <xsl:template name="content-tag">
        <xsl:if test="metadata/category">
            <span class="tag">
                <xsl:value-of select="metadata/category/@title"/>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <div class="date-container">
            <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="@createdAt"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="ugc:getUgcPage(//content/@id)"/>
    </xsl:template>
    
</xsl:stylesheet>
