<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="ads.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">service-annonce</xsl:variable>    
    
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('plugins/css/simple-lightbox.min.css')}" type="text/css" />
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/simple-lightbox.jquery.min.js')}"/>
        <script type="text/javascript">
            $j(document).ready(function () {
                $j('.service-gallery a').simpleLightbox();
            });
        </script>
    </xsl:template>
        
    <xsl:template name="common-content-body-content">

		<h1 class="ametys-richtext-title-1">
			<i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_DETAIL" i18n:catalogue="skin.{$skin}"/>
		</h1>
                  
		<!-- Rich content -->
		<xsl:call-template name="common-content-body-content-rich"/>

		<div class="annonces-block">
                 	
			<!-- Prix -->
			<xsl:call-template name="ads-price"/>
                 		
			<!-- Localisation -->
			<xsl:call-template name="ads-location"/>
			
			<!-- Contact -->
			<xsl:call-template name="ads-contact"/>
			
		 </div>	
        
        <!-- Images -->
        <xsl:call-template name="ads-photos" />
        
    </xsl:template> 
    
    <xsl:template name="ads-price">
    	<xsl:if test="metadata/price != '' and metadata/price != '0.0'">
			<div class="block price">
				<div class="icon">
					<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="enable-background:new 0 0 512 512;" viewBox="0 0 512 512" y="0px" x="0px" id="Capa_1" version="1.1">
    					<g>
    						<g>
    							<path d="M256,0C114.8,0,0,114.8,0,256s114.8,256,256,256s256-114.8,256-256S397.2,0,256,0z M256,480C132.5,480,32,379.5,32,256    S132.5,32,256,32s224,100.5,224,224S379.5,480,256,480z" />
    						</g>
    					</g>
    					<g>
    						<g>
    							<path d="M311,339.7c-11.9,8.1-25,12.3-39,12.3c-29.5,0-55-19.5-68.9-48H256c8.8,0,16-7.2,16-16s-7.2-16-16-16h-62.7    c-0.7-5.2-1.3-10.5-1.3-16c0-5.5,0.6-10.8,1.3-16H272c8.8,0,16-7.2,16-16s-7.2-16-16-16h-68.9c13.9-28.5,39.4-48,68.9-48    c14,0,27.1,4.1,39,12.3c7.3,5,17.3,3.1,22.2-4.2c5-7.3,3.1-17.2-4.2-22.2c-17.1-11.6-36.8-17.8-57-17.8c-46.9,0-87,33.2-103.7,80    H144c-8.8,0-16,7.2-16,16s7.2,16,16,16h17.4c-0.6,5.3-1.4,10.5-1.4,16c0,5.5,0.8,10.7,1.4,16H144c-8.8,0-16,7.2-16,16    s7.2,16,16,16h24.3c16.7,46.8,56.8,80,103.7,80c20.2,0,39.9-6.2,57-17.8c7.3-5,9.2-14.9,4.2-22.2    C328.3,336.6,318.3,334.8,311,339.7z" />
    						</g>
    					</g>
    				</svg>
			     </div>
    			<span class="title">
    				<i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_PRICE" i18n:catalogue="skin.{$skin}"/>
    			</span>
    			<span class="value">
    				<xsl:choose>
                        <xsl:when test="contains(metadata/price, '.0')"><xsl:value-of select="substring-before(metadata/price, '.0')"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="translate(metadata/price, '.', ',')"/></xsl:otherwise>
                    </xsl:choose>
                    <xsl:text> </xsl:text>
    				<i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_PRICE_UNIT" i18n:catalogue="skin.{$skin}"/>
    			</span>
    	   </div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-location">
		<xsl:if test="metadata/location != ''">
	       <div class="block loca">
	           <div class="icon">
	               <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
	                   xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
	                   style="enable-background:new 0 0 512 512;" xml:space="preserve">
	                   <g>
	                       <g>
	                           <path d="M256,0C156.7,0,76,80.7,76,180c0,33.5,9.3,66.3,26.9,94.7l142.9,230.3c2.7,4.4,7.6,7.1,12.7,7.1c0,0,0.1,0,0.1,0
	                  c5.2,0,10.1-2.8,12.8-7.3l139.2-232.5c16.6-27.8,25.4-59.7,25.4-92.2C436,80.7,355.3,0,256,0z M384.9,256.8L258.3,468.2
	                  L128.4,258.8c-14.6-23.6-22.6-50.9-22.6-78.8c0-82.7,67.5-150.2,150.2-150.2S406.1,97.3,406.1,180
	                  C406.1,207.1,398.7,233.7,384.9,256.8z" />
	                       </g>
	                   </g>
	                   <g>
	                       <g>
	                           <path
	                               d="M256,90c-49.6,0-90,40.4-90,90c0,49.3,39.7,90,90,90c50.9,0,90-41.2,90-90C346,130.4,305.6,90,256,90z M256,240.2
	                  c-33.3,0-60.2-27-60.2-60.2c0-33.1,27.1-60.2,60.2-60.2s60.1,27.1,60.1,60.2C316.1,212.7,289.8,240.2,256,240.2z" />
	                       </g>
	                   </g>
	               </svg>
	
	           </div>
	           <span class="title"><i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_LOCALISATION" i18n:catalogue="skin.{$skin}"/></span>
	           <span class="value"><xsl:value-of select="metadata/location"/></span>
	        </div>
		</xsl:if>
    </xsl:template>
    
    
    <xsl:template name="ads-contact">
        
        <xsl:variable name="contactName" select="ametys:contentAttribute(/view/content/@id, 'ugc-contact/name')"/>
        <xsl:variable name="contactMail" select="ametys:contentAttribute(/view/content/@id, 'ugc-contact/mail')"/>
        
    	<xsl:if test="$contactName != '' or $contactMail != '' or metadata/phone != ''">
	         <div class="block contact">
	             <div class="icon">
	                 <!-- Generator: Adobe Illustrator 25.0.1, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
	                 <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
	                     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512"
	                     style="enable-background:new 0 0 512 512;" xml:space="preserve">
	                     <g>
	                         <g>
	                             <path d="M467,76H45C20.1,76,0,96.3,0,121v270c0,24.9,20.3,45,45,45h422c24.7,0,45-20,45-45V121C512,96.3,491.9,76,467,76z
	                          M460.7,106c-9.2,9.1-167.4,166.5-172.9,172c-8.5,8.5-19.8,13.2-31.8,13.2s-23.3-4.7-31.8-13.2C220.5,274.3,64,118.6,51.3,106
	                         H460.7z M30,384.9V127.1l129.6,129L30,384.9z M51.3,406l129.6-128.8l22.1,21.9c14.2,14.2,33,22,53,22s38.9-7.8,53-21.9l22.1-22
	                         L460.7,406H51.3z M482,384.9L352.4,256.1l129.6-129V384.9z" fill="#fff" />
	                         </g>
	                     </g>
	                 </svg>
	
	             </div>
	             <span class="title"><i18n:text i18n:key="SKIN_CONTENT_ADS_MAIN_CONTACT" i18n:catalogue="skin.{$skin}"/></span>
	
				<xsl:if test="$contactName != ''">
              		<span class="name">
              			<xsl:value-of select="$contactName"/>
              		</span>
             	</xsl:if>
             	<xsl:if test="$contactMail != ''">
             		<div class="link-container">
						<xsl:call-template name="mail-antispam">
				    		<xsl:with-param name="mail" select="$contactMail"></xsl:with-param>
				    		<xsl:with-param name="class" select="'mailto'" />
						</xsl:call-template>
					</div>
				</xsl:if>
				<xsl:if test="metadata/phone != ''">
					<span class="value">
						<xsl:value-of select="metadata/phone"/>
					</span>
	        	</xsl:if>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-photos">
        <xsl:if test="metadata/illustrations/*">
	        <div class="service-gallery">
	            <div class="container-gallery">
                    <xsl:for-each select="metadata/illustrations/*">
                        <xsl:call-template name="photo">
                            <xsl:with-param name="image" select="."/>
                        </xsl:call-template>
                    </xsl:for-each>
	            </div>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="photo">
        <xsl:param name="image" />
        <xsl:param name="maxWidth">380</xsl:param>
        <xsl:param name="maxHeight">220</xsl:param>
        
        <a href="{resolver:resolve($image/@type, $image/@path)}" title="{$image/@filename}">
            <xsl:if test="$rendering-context = 'back'">
                <xsl:attribute name="internal">internal</xsl:attribute>
            </xsl:if>
            
            <img src="{resolver:resolveCroppedImage($image/@type, $image/@path, $maxHeight, $maxWidth)}" alt="{$image/@filename}"/>
        </a>
    </xsl:template>

</xsl:stylesheet>