<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
            	xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common" 
                exclude-result-prefixes="ametys docbook resolver exslt">    
    
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="content-image"/>
            <div class="infos"> 
                <xsl:call-template name="content-tag"/>
                <xsl:call-template name="content-title"/>
                <xsl:call-template name="content-abstract"/>
                <xsl:call-template name="content-dates"/>
            </div>
        </a>
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/svgconvert.js')}" />
    </xsl:template>
    
    <xsl:template name="content-image">
        <div class="picture">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <xsl:call-template name="common-content-body-image-bigsize">
                        <xsl:with-param name="maxWidth" select="'300'"/>
                        <xsl:with-param name="maxHeight" select="'200'"/>
                        <xsl:with-param name="type" select="'cropped'"/>
                    </xsl:call-template>    
                </xsl:when>
                <xsl:when test="metadata/file/@filename">
                    <xsl:call-template name="file-icon">
                        <xsl:with-param name="filename" select="metadata/file/@filename"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="content-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="content-default-image">
        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/article.svg')}"/>
    </xsl:template>
    
    <xsl:template name="content-tag">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
    	<xsl:for-each select="exslt:node-set($tags)/tag[position() &lt;= 3]">
           <span class="tag">
                <xsl:if test="$useTagColor and @bgColor">
                    <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                </xsl:if>
                <xsl:value-of select="." />
           </span>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <div class="date-container">
            <xsl:choose>
                <xsl:when test="metadata/start-date != '' or metadata/end-date != ''">
                    <xsl:call-template name="dates">
                        <xsl:with-param name="startDate" select="metadata/start-date"/>
                        <xsl:with-param name="endDate" select="metadata/end-date"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="metadata/file/@lastModified">
                    <xsl:call-template name="dates">
                        <xsl:with-param name="startDate" select="metadata/file/@lastModified"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="@lastValidatedAt">
                    <xsl:call-template name="dates">
                        <xsl:with-param name="startDate" select="@lastValidatedAt"/>
                        <xsl:with-param name="textBefore"><i18n:text i18n:key="CONTENT_VIEW_LASTPUBLICATIONDATE" i18n:catalogue="plugin.cms"/><xsl:text> </xsl:text></xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <span class="title">
            <xsl:value-of select="metadata/title"/>
        </span>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:param name="maxLength">150</xsl:param>
        
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">descri</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="$maxLength" />
        </xsl:call-template>
    </xsl:template>
    
    <!-- Template used to display the content illustration -->
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth" select="'300'"/>
        <xsl:param name="maxHeight" select="'300'"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <img alt="{$alternative}">
                <xsl:attribute name="src">
                    <xsl:choose>
                        <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </img>
        </xsl:if>        
    </xsl:template>  
    
    <!-- Illustration big size -->
    <xsl:template name="common-content-body-image-bigsize">
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alternative" select="metadata/illustration/alt-text"/>
        <xsl:param name="maxWidth" select="'510'"/>
        <xsl:param name="maxHeight" select="'395'"/>
        <xsl:param name="class" select="'big'"/>
        <xsl:param name="type" select="'bounded'"/>
        
        <xsl:call-template name="common-content-body-image">
            <xsl:with-param name="image" select="$image"/>
            <xsl:with-param name="alternative" select="$alternative"/>
            <xsl:with-param name="maxWidth" select="$maxWidth"/>
            <xsl:with-param name="maxHeight" select="$maxHeight"/>
            <xsl:with-param name="class" select="$class"/>
            <xsl:with-param name="type" select="$type"/>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>    